/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;

class BaseClassLookup {
    private final ICPPClassType fClassType;
    private IBinding[] fBindings;
    private List<BaseClassLookup> fChildren = Collections.emptyList();
    private BitSet fVirtual;
    private boolean fHiddenAsVirtualBase;
    private boolean fPropagationDone;
    private boolean fCollected;
    private boolean fCollectedAsRegularBase;
    private final IASTNode fLookupPoint;

    public static void lookupInBaseClasses(LookupData data, ICPPClassScope classScope) {
        if (classScope == null) {
            return;
        }
        ICPPClassType classType = classScope.getClassType();
        if (classType == null) {
            return;
        }
        HashMap<IScope, BaseClassLookup> infoMap = new HashMap<IScope, BaseClassLookup>();
        BaseClassLookup rootInfo = BaseClassLookup.lookupInBaseClass(data, null, false, classType, infoMap, 0);
        if (data.contentAssist) {
            rootInfo.collectResultForContentAssist(data);
        } else {
            BaseClassLookup.hideVirtualBases(rootInfo, infoMap);
            Object[] result = rootInfo.collectResult(data, true, IBinding.EMPTY_BINDING_ARRAY);
            if (data.problem == null) {
                data.foundItems = ArrayUtil.addAll((Object[])data.foundItems, result);
            } else if (result.length > 0) {
                data.problem.setCandidateBindings((IBinding[])result);
            }
        }
    }

    private BaseClassLookup(ICPPClassType type, IASTNode lookupPoint) {
        this.fClassType = type;
        this.fLookupPoint = lookupPoint;
    }

    ICPPClassType getClassType() {
        return this.fClassType;
    }

    IBinding[] getResult() {
        return this.fBindings;
    }

    boolean containsVirtualBase() {
        return this.fVirtual != null && this.fVirtual.nextSetBit(0) >= 0;
    }

    boolean hasMatches() {
        return this.fBindings != null && this.fBindings.length > 0 && this.fBindings[0] != null;
    }

    public void addBase(boolean virtual, BaseClassLookup baseInfo) {
        if (virtual && this.fHiddenAsVirtualBase) {
            return;
        }
        if (this.fChildren.isEmpty()) {
            this.fChildren = new ArrayList<BaseClassLookup>();
            this.fVirtual = new BitSet();
        }
        this.fVirtual.set(this.fChildren.size(), virtual);
        this.fChildren.add(baseInfo);
    }

    public void setResult(IBinding[] bindings) {
        this.fBindings = bindings;
    }

    public void setHiddenAsVirtualBase() {
        this.fHiddenAsVirtualBase = true;
    }

    public void propagateHiddenAsVirtual() {
        if (this.fPropagationDone) {
            return;
        }
        this.fPropagationDone = true;
        int i = 0;
        while (i < this.fChildren.size()) {
            BaseClassLookup child = this.fChildren.get(i);
            if (this.fVirtual.get(i)) {
                child.setHiddenAsVirtualBase();
            }
            child.propagateHiddenAsVirtual();
            ++i;
        }
    }

    public boolean containsNonStaticMember() {
        IBinding[] iBindingArray = this.fBindings;
        int n = this.fBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding == null) {
                return false;
            }
            if (binding instanceof ICPPMember && !((ICPPMember)binding).isStatic()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static BaseClassLookup lookupInBaseClass(LookupData data, ICPPClassScope baseClassScope, boolean isVirtual, ICPPClassType root, HashMap<IScope, BaseClassLookup> infoMap, int depth) {
        ICPPBase[] grandBases;
        int i;
        BaseClassLookup result;
        IBinding[] matches;
        block23: {
            BaseClassLookup info;
            if (depth++ > 40) {
                return null;
            }
            if (baseClassScope != null && (info = infoMap.get(baseClassScope)) != null) {
                if (info.getResult() == null) {
                    data.problem = new ProblemBinding(null, 6, root.getNameCharArray());
                    return null;
                }
                return info;
            }
            matches = IBinding.EMPTY_BINDING_ARRAY;
            if (baseClassScope == null) {
                result = new BaseClassLookup(root, data.getLookupPoint());
                infoMap.put(root.getCompositeScope(), result);
            } else {
                result = new BaseClassLookup(baseClassScope.getClassType(), data.getLookupPoint());
                infoMap.put(baseClassScope, result);
                try {
                    IBinding[] members;
                    IASTName lookupName;
                    ICPPASTNameSpecifier nameQualifier = null;
                    if (data.qualified && (lookupName = data.getLookupName()) != null && lookupName.getPropertyInParent() == ICPPASTQualifiedName.SEGMENT_NAME && lookupName.getRoleOfName(false) == 2) {
                        ICPPASTQualifiedName qName = (ICPPASTQualifiedName)lookupName.getParent();
                        ICPPASTNameSpecifier[] qualifiers = qName.getQualifier();
                        i = 0;
                        while (i < qualifiers.length && lookupName != qualifiers[i]) {
                            nameQualifier = qualifiers[i];
                            ++i;
                        }
                    }
                    IName baseClassScopeName = baseClassScope.getScopeName();
                    if (nameQualifier != null && (baseClassScopeName == null || !Arrays.equals(baseClassScopeName.getSimpleID(), nameQualifier.toCharArray())) || (members = CPPSemantics.getBindingsFromScope(baseClassScope, data)) == null || members.length <= 0 || members[0] == null) break block23;
                    if (data.isPrefixLookup()) {
                        matches = members;
                        break block23;
                    }
                    result.setResult(members);
                    return result;
                }
                catch (DOMException nameQualifier) {
                    // empty catch block
                }
            }
        }
        ICPPClassType baseClass = result.getClassType();
        if (baseClass != null && (grandBases = baseClass.getBases()) != null && grandBases.length > 0) {
            HashSet<ICPPClassType> grandBaseBindings = null;
            BitSet selectedBases = null;
            if (grandBases.length > 1) {
                grandBaseBindings = new HashSet<ICPPClassType>();
                selectedBases = BaseClassLookup.selectPreferredBases(data, grandBases);
            }
            i = 0;
            while (i < grandBases.length) {
                ICPPBase grandBase = grandBases[i];
                if (selectedBases == null || selectedBases.get(i)) {
                    IBinding grandBaseBinding = grandBase.getBaseClass();
                    if (!(grandBaseBinding instanceof ICPPClassType)) {
                        if (grandBaseBinding instanceof ICPPUnknownBinding && data.skippedScope == null) {
                            data.skippedScope = root;
                        }
                    } else {
                        ICPPClassType grandBaseClass = (ICPPClassType)grandBaseBinding;
                        if (data.fHeuristicBaseLookup && grandBaseClass instanceof ICPPDeferredClassInstance) {
                            grandBaseClass = ((ICPPDeferredClassInstance)grandBaseClass).getClassTemplate();
                        }
                        if (grandBaseBindings == null || grandBaseBindings.add(grandBaseClass)) {
                            BaseClassLookup baseInfo;
                            IScope grandBaseScope = grandBaseClass.getCompositeScope();
                            if (grandBaseScope == null || grandBaseScope instanceof ICPPInternalUnknownScope) {
                                if (data.skippedScope == null) {
                                    data.skippedScope = root;
                                }
                            } else if (grandBaseScope instanceof ICPPClassScope && (baseInfo = BaseClassLookup.lookupInBaseClass(data, (ICPPClassScope)grandBaseScope, grandBase.isVirtual(), root, infoMap, depth)) != null) {
                                result.addBase(grandBase.isVirtual(), baseInfo);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        result.setResult(matches);
        return result;
    }

    private static BitSet selectPreferredBases(LookupData data, ICPPBase[] grandBases) {
        if (data.contentAssist) {
            return null;
        }
        BitSet selectedBases = new BitSet(grandBases.length);
        IName baseName = null;
        int i = 0;
        while (i < grandBases.length) {
            ICPPBase nbase = grandBases[i];
            if (!(nbase instanceof IProblemBinding)) {
                int cmp;
                IName nbaseName = nbase.getClassDefinitionName();
                int n = cmp = baseName == null ? 0 : CPPSemantics.compareByRelevance(data, baseName, nbaseName);
                if (cmp <= 0) {
                    if (cmp < 0) {
                        selectedBases.clear();
                        baseName = nbaseName;
                    }
                    selectedBases.set(i);
                }
            }
            ++i;
        }
        return selectedBases;
    }

    static void hideVirtualBases(BaseClassLookup rootInfo, HashMap<IScope, BaseClassLookup> infoMap) {
        BaseClassLookup info;
        BaseClassLookup[] allInfos;
        boolean containsVirtualBase = false;
        BaseClassLookup[] baseClassLookupArray = allInfos = infoMap.values().toArray(new BaseClassLookup[infoMap.size()]);
        int n = allInfos.length;
        int n2 = 0;
        while (n2 < n) {
            info = baseClassLookupArray[n2];
            if (info.containsVirtualBase()) {
                containsVirtualBase = true;
                break;
            }
            ++n2;
        }
        if (containsVirtualBase) {
            baseClassLookupArray = allInfos;
            n = allInfos.length;
            n2 = 0;
            while (n2 < n) {
                info = baseClassLookupArray[n2];
                if (info.hasMatches()) {
                    info.hideVirtualBases(infoMap, 0);
                }
                ++n2;
            }
        }
    }

    void hideVirtualBases(HashMap<IScope, BaseClassLookup> infoMap, int depth) {
        if (depth++ > 40) {
            return;
        }
        if (this.fClassType != null) {
            ICPPBase[] bases = null;
            bases = this.fClassType.getBases();
            if (bases != null && bases.length > 0) {
                ICPPBase[] iCPPBaseArray = bases;
                int n = bases.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassType baseClass;
                    IScope baseScope;
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding baseBinding = base.getBaseClass();
                    if (baseBinding instanceof ICPPClassType && (baseScope = (baseClass = (ICPPClassType)baseBinding).getCompositeScope()) instanceof ICPPClassScope) {
                        BaseClassLookup baseInfo = infoMap.get(baseScope);
                        if (baseInfo != null) {
                            if (base.isVirtual()) {
                                baseInfo.setHiddenAsVirtualBase();
                            }
                            baseInfo.propagateHiddenAsVirtual();
                        } else {
                            baseInfo = new BaseClassLookup(baseClass, this.fLookupPoint);
                            infoMap.put(baseScope, baseInfo);
                            baseInfo.hideVirtualBases(infoMap, depth);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public void collectResultForContentAssist(LookupData data) {
        if (this.fCollected) {
            return;
        }
        this.fCollected = true;
        CharArrayObjectMap resultMap = (CharArrayObjectMap)data.foundItems;
        data.foundItems = CPPSemantics.mergePrefixResults(resultMap, this.fBindings, true);
        int i = 0;
        while (i < this.fChildren.size()) {
            BaseClassLookup child = this.fChildren.get(i);
            child.collectResultForContentAssist(data);
            ++i;
        }
    }

    private IBinding[] collectResult(LookupData data, boolean asVirtualBase, IBinding[] result) {
        if (asVirtualBase) {
            if (this.fHiddenAsVirtualBase) {
                return result;
            }
        } else {
            if (this.fCollectedAsRegularBase && data.problem == null && this.containsNonStaticMember()) {
                data.problem = new ProblemBinding(data.getLookupName(), 4);
            }
            this.fCollectedAsRegularBase = true;
        }
        if (this.fCollected) {
            return result;
        }
        this.fCollected = true;
        int numBindingsToAdd = 0;
        int i = 0;
        while (i < this.fBindings.length) {
            IBinding binding = this.fBindings[i];
            if (binding == null) break;
            if (!ArrayUtil.contains(result, binding)) {
                this.fBindings[numBindingsToAdd++] = binding;
            }
            ++i;
        }
        if (numBindingsToAdd < this.fBindings.length) {
            this.fBindings[numBindingsToAdd] = null;
        }
        boolean possibleAmbiguity = false;
        if (result.length > 0 && numBindingsToAdd > 0 && data.problem == null) {
            possibleAmbiguity = true;
        }
        result = ArrayUtil.addAll(result, this.fBindings);
        if (possibleAmbiguity && (result = this.collapseInjectedClassNames(data, result)).length > 1) {
            data.problem = new ProblemBinding(data.getLookupName(), 4, result);
        }
        int i2 = 0;
        while (i2 < this.fChildren.size()) {
            BaseClassLookup child = this.fChildren.get(i2);
            result = child.collectResult(data, this.fVirtual.get(i2), result);
            ++i2;
        }
        return result;
    }

    private IBinding[] collapseInjectedClassNames(LookupData data, IBinding[] result) {
        IASTName lookupName = data.getLookupName();
        if (lookupName == null || lookupName.getPropertyInParent() != ICPPASTTemplateId.TEMPLATE_NAME) {
            return result;
        }
        ICPPTemplateDefinition template = null;
        IBinding[] iBindingArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                block6: {
                    ICPPTemplateDefinition specialized;
                    block7: {
                        IBinding binding = iBindingArray[n2];
                        if (!(binding instanceof ICPPClassType) || !(binding instanceof ICPPTemplateInstance)) break block6;
                        specialized = (ICPPTemplateDefinition)((ICPPTemplateInstance)binding).getSpecializedBinding();
                        if (template != null) break block7;
                        template = specialized;
                        break block8;
                    }
                    if (template == specialized) break block8;
                }
                return result;
            }
            ++n2;
        }
        if (template != null) {
            return new IBinding[]{template};
        }
        return result;
    }
}

