/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph;

import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.BaseDataProviderTimeGraphMultiViewer;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.markers.MarkerUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ActionsDataProviderTimeGraphMultiViewer
extends BaseDataProviderTimeGraphMultiViewer {
    private static final String HIDE_LABELS_KEY = "hide.labels";
    private MenuManager fMarkerSetMenu;

    public ActionsDataProviderTimeGraphMultiViewer(Composite parent, ITimeGraphPresentationProvider pres, IWorkbenchPartSite site, String providerId) {
        super(parent, pres, site, providerId);
    }

    @Override
    protected void fillTimeEventContextMenu(@NonNull IMenuManager menuManager) {
        TimeGraphViewer timeGraphViewer = this.getTimeGraphViewer();
        menuManager.add((IAction)timeGraphViewer.getShowFilterDialogAction());
        menuManager.add((IAction)timeGraphViewer.getShowLegendAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)timeGraphViewer.getGridlinesMenu());
        menuManager.add((IAction)this.getShowLabelsAction());
        menuManager.add((IContributionItem)timeGraphViewer.getMarkersMenu());
        menuManager.add((IContributionItem)this.getMarkerSetMenu());
        super.fillTimeEventContextMenu(menuManager);
    }

    protected MenuManager getMarkerSetMenu() {
        if (this.fMarkerSetMenu != null) {
            return this.fMarkerSetMenu;
        }
        this.fMarkerSetMenu = new MenuManager(Messages.AbstractTimeGraphView_MarkerSetMenuText);
        this.fMarkerSetMenu.setRemoveAllWhenShown(true);
        this.fMarkerSetMenu.addMenuListener(mgr -> {
            MarkerSetAction noneAction = new MarkerSetAction(null);
            MarkerSet defaultMarkerSet = MarkerUtils.getDefaultMarkerSet();
            String defaultMarkerSetId = defaultMarkerSet == null ? null : defaultMarkerSet.getId();
            noneAction.setChecked(defaultMarkerSetId == null);
            mgr.add((IAction)noneAction);
            List markerSets = MarkerConfigXmlParser.getMarkerSets();
            for (MarkerSet markerSet : markerSets) {
                MarkerSetAction action = new MarkerSetAction(markerSet);
                action.setChecked(markerSet.getId().equals(defaultMarkerSetId));
                mgr.add((IAction)action);
            }
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new Action(Messages.AbstractTimeGraphView_MarkerSetEditActionText){

                public void run() {
                    MarkerConfigXmlParser.initMarkerSets();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(MarkerConfigXmlParser.MARKER_CONFIG_PATH);
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().logError("Error opening editor on " + String.valueOf(MarkerConfigXmlParser.MARKER_CONFIG_PATH), (Throwable)e);
                    }
                }
            });
        });
        return this.fMarkerSetMenu;
    }

    protected Action getShowLabelsAction() {
        Action showLabelsAction = new Action(Messages.AbstractTimeGraphView_ShowLabelsActionText, 2){

            public void run() {
                boolean showLabels = this.isChecked();
                ActionsDataProviderTimeGraphMultiViewer.this.getTimeGraphViewer().setLabelsVisible(showLabels);
                ActionsDataProviderTimeGraphMultiViewer.this.redraw();
                IDialogSettings dialogSettings = ActionsDataProviderTimeGraphMultiViewer.this.getDialogSettings(true);
                dialogSettings.put(ActionsDataProviderTimeGraphMultiViewer.HIDE_LABELS_KEY, !showLabels);
            }
        };
        boolean showLabels = true;
        IDialogSettings dialogSettings = this.getDialogSettings(false);
        if (dialogSettings != null) {
            showLabels = !dialogSettings.getBoolean(HIDE_LABELS_KEY);
        }
        showLabelsAction.setChecked(showLabels);
        this.getTimeGraphViewer().setLabelsVisible(showLabels);
        return showLabelsAction;
    }

    private IDialogSettings getDialogSettings(boolean force) {
        String sectionName;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName = this.getSite().getId());
        if (section == null && force) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    private class MarkerSetAction
    extends Action {
        private MarkerSet fMarkerSet;

        public MarkerSetAction(MarkerSet markerSet) {
            super(markerSet == null ? Messages.AbstractTimeGraphView_MarkerSetNoneActionText : markerSet.getName(), 8);
            this.fMarkerSet = markerSet;
        }

        public void runWithEvent(Event event) {
            if (this.isChecked()) {
                MarkerUtils.setDefaultMarkerSet((MarkerSet)this.fMarkerSet);
                ActionsDataProviderTimeGraphMultiViewer.this.broadcast((TmfSignal)new TmfMarkerEventSourceUpdatedSignal((Object)ActionsDataProviderTimeGraphMultiViewer.this));
            }
        }
    }
}

