/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor.Ros2ExecutorAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor.Ros2ExecutorTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.executor.Ros2ExecutorStateInstance;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Ros2ExecutorDataProvider
extends AbstractTimeGraphDataProvider<Ros2ExecutorAnalysis, TimeGraphEntryModel> {
    public static final String SUFFIX = ".dataprovider";

    public Ros2ExecutorDataProvider(@NonNull ITmfTrace trace, @NonNull Ros2ExecutorAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return ((Ros2ExecutorAnalysis)this.getAnalysisModule()).getId() + SUFFIX;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TimeGraphModel getRowModel(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        @NonNull Collection times = Ros2ExecutorDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        Collection valuesNull = entries.values();
        Collection timesNull = times;
        for (ITmfStateInterval interval : ss.query2D(valuesNull, timesNull)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            ArrayList eventList = new ArrayList();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object valObject = interval.getValue();
                if (!(valObject instanceof Ros2ExecutorStateInstance)) continue;
                Ros2ExecutorStateInstance executorStateInstance = (Ros2ExecutorStateInstance)((Object)valObject);
                Ros2ExecutorTimeGraphState state = new Ros2ExecutorTimeGraphState(startTime, duration, executorStateInstance);
                this.applyFilterAndAddState(eventList, (ITimeGraphState)state, (Long)entry.getKey(), predicates, monitor);
            }
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull TmfTreeModel<@NonNull TimeGraphEntryModel> getTree(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(parentId, -1L, String.valueOf(this.getTrace().getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        this.addChildren(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void addChildren(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            String grandChildName;
            long childId = this.getId(child);
            String name = ss.getAttributeName(child.intValue());
            if (-1 == quark) {
                HostInfo hostInfo = Ros2ExecutorDataProvider.getHostInfo(ss, child);
                if (hostInfo == null) continue;
                @NonNull ArrayList labels = Lists.newArrayList((Object[])new String[]{name, hostInfo.getHostname(), hostInfo.getId()});
                builder.add((Object)new TimeGraphEntryModel(childId, parentId, (List)Objects.requireNonNull(labels), ss.getStartTime(), ss.getCurrentEndTime(), true));
                this.addChildren(ss, builder, child, childId);
                continue;
            }
            boolean isRowModel = child != -1;
            @NonNull List grandChildrenQuarks = ss.getSubAttributes(child.intValue(), false);
            String string = grandChildName = !grandChildrenQuarks.isEmpty() ? ss.getAttributeName(((Integer)grandChildrenQuarks.get(0)).intValue()) : null;
            if (grandChildrenQuarks.size() == 1 && grandChildName != null && grandChildName.equals(name)) {
                Integer grandchild = (Integer)grandChildrenQuarks.get(0);
                childId = this.getId(grandchild);
                builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), isRowModel));
                continue;
            }
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), isRowModel));
            this.addChildren(ss, builder, child, childId);
        }
    }

    private static @Nullable HostInfo getHostInfo(ITmfStateSystem ss, int quark) {
        ITmfStateInterval stateInterval;
        block3: {
            try {
                stateInterval = ss.querySingleState(ss.getStartTime(), quark);
                if (stateInterval.getValue() instanceof HostInfo) break block3;
                return null;
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                return null;
            }
        }
        return (HostInfo)stateInterval.getValue();
    }

    public static String getFullDataProviderId() {
        return Ros2ExecutorAnalysis.getFullAnalysisId() + SUFFIX;
    }
}

