/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views.messageflow;

import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.RosMessageFlowAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.RosMessageFlowDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.RosMessageFlowSegmentEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.RosMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.AbstractRosView;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.messageflow.RosMessageFlowPresentationProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class RosMessageFlowView
extends AbstractRosView {
    public static final String ID_SUFFIX = "messageflow";
    private static final String[] TREE_COLUMNS = new String[]{"Node", "Type", "Topic", "Segment type"};

    public RosMessageFlowView() {
        super(ID_SUFFIX, new RosMessageFlowPresentationProvider(), RosMessageFlowDataProvider.getFullDataProviderId());
        this.setTreeColumns(TREE_COLUMNS);
        this.setTreeLabelProvider(new RosMessageFlowTreeLabelProvider());
        this.setFilterColumns(new String[]{""});
        this.setFilterLabelProvider(new RosViewFilterLabelProvider());
    }

    private static @Nullable String getQueueTypeName(RosMessageFlowSegment.SegmentType type) {
        switch (type) {
            case SUB_QUEUE: 
            case SUB_CALLBACK: {
                return "Subscribers";
            }
            case PUB_QUEUE: {
                return "Publishers";
            }
        }
        return null;
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        IDialogSettings settings = Objects.requireNonNull(Activator.getDefault()).getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphViewer().getHideArrowsAction(section);
        manager.appendToGroup("additions", (IAction)hideArrowsAction);
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @TmfSignalHandler
    public void analysisStarted(TmfStartAnalysisSignal signal) {
        IAnalysisModule analysis = signal.getAnalysisModule();
        if (analysis instanceof RosMessageFlowAnalysis) {
            this.rebuild();
        }
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return trace != null ? Collections.singleton(trace) : Collections.emptyList();
    }

    public static String getFullViewId() {
        return "org.eclipse.tracecompass.incubator.ros.ui.views.messageflow";
    }

    private static class RosMessageFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private RosMessageFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            ITmfTreeDataModel model = entry.getEntryModel();
            if (model instanceof RosMessageFlowSegmentEntryModel) {
                RosMessageFlowSegmentEntryModel segmentModel = (RosMessageFlowSegmentEntryModel)model;
                RosMessageFlowSegment segment = segmentModel.getSegment();
                if (columnIndex >= 0 && columnIndex < TREE_COLUMNS.length) {
                    if (columnIndex == 0) {
                        return segment.getNodeName();
                    }
                    if (columnIndex == 1) {
                        return RosMessageFlowView.getQueueTypeName(segment.getType());
                    }
                    if (columnIndex == 2) {
                        return segment.getTopicName();
                    }
                    if (columnIndex == 3) {
                        return segment.getType().name();
                    }
                }
            } else if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }

    private static class RosViewFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private RosViewFilterLabelProvider() {
        }
    }
}

