/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.ILog;
import org.eclipse.help.AbstractContentExtensionProvider;
import org.eclipse.help.IContentExtension;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.remote.HttpsUtility;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.dynamic.DocumentReader;

public class RemoteExtensionProvider
extends AbstractContentExtensionProvider {
    private static final String PATH_EXTENSIONS = "/extension";
    private static final String PROTOCOL_HTTP = "http";
    private DocumentReader reader;

    public RemoteExtensionProvider() {
        RemoteHelp.addPreferenceChangeListener(event -> this.contentChanged());
    }

    public IContentExtension[] getContentExtensions(String locale) {
        if (RemoteHelp.isEnabled()) {
            ArrayList contributions = new ArrayList();
            PreferenceFileHandler handler = new PreferenceFileHandler();
            String[] isEnabled = handler.isEnabled();
            int ic = 0;
            while (ic < handler.getTotalRemoteInfocenters()) {
                block21: {
                    if (isEnabled[ic].equalsIgnoreCase("true")) {
                        String msg;
                        InputStream in = null;
                        try {
                            URL url = RemoteHelp.getURL(ic, PATH_EXTENSIONS);
                            in = url.getProtocol().equalsIgnoreCase(PROTOCOL_HTTP) ? ProxyUtil.getStream(url) : HttpsUtility.getHttpsStream(url);
                            if (this.reader == null) {
                                this.reader = new DocumentReader();
                            }
                            UAElement element = this.reader.read(in);
                            IContentExtension[] children = (IContentExtension[])element.getChildren(IContentExtension.class);
                            Collections.addAll(contributions, children);
                        }
                        catch (IOException e) {
                            msg = "I/O error while trying to contact the remote help server";
                            ILog.of(((Object)((Object)this)).getClass()).error(msg, (Throwable)e);
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block21;
                        }
                        catch (Throwable t) {
                            try {
                                msg = "Internal error while reading topic extensions from remote server";
                                ILog.of(((Object)((Object)this)).getClass()).error(msg, t);
                                break block21;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (in == null) break block21;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                ++ic;
            }
            return contributions.toArray(new IContentExtension[contributions.size()]);
        }
        return new IContentExtension[0];
    }
}

