/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.AbstractXmlViewInfo;

public class XmlLatencyViewInfo
extends AbstractXmlViewInfo {
    private static final String XML_LATENCY_VIEW_ANALYSIS_ID_PROPERTY = "XmlLatencyAnalysisId";
    private static final String XML_LATENCY_VIEW_LABEL_PROPERTY = "XmlLatencyViewLabel";
    private @Nullable String fAnalysisId = null;
    private @Nullable String fLabel = null;
    private boolean fIsDirty = false;

    public XmlLatencyViewInfo(String viewId) {
        super(viewId);
        IDialogSettings settings = this.getPersistentPropertyStore();
        this.fAnalysisId = settings.get(XML_LATENCY_VIEW_ANALYSIS_ID_PROPERTY);
        this.fLabel = settings.get(XML_LATENCY_VIEW_LABEL_PROPERTY);
    }

    public String getViewAnalysisId() {
        return this.fAnalysisId;
    }

    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public synchronized void setName(String name) {
        super.setName(name);
        if (this.fIsDirty) {
            this.savePersistentData();
        } else {
            IDialogSettings settings = this.getPersistentPropertyStore();
            this.fAnalysisId = settings.get(XML_LATENCY_VIEW_ANALYSIS_ID_PROPERTY);
            this.fLabel = settings.get(XML_LATENCY_VIEW_LABEL_PROPERTY);
        }
    }

    @Override
    public void setViewData(String data) {
        String[] idFile = data.split(";;;");
        this.fAnalysisId = idFile.length > 0 ? idFile[0] : null;
        this.fLabel = idFile.length > 1 ? idFile[1] : null;
        String viewSubsectionName = this.getName();
        if (viewSubsectionName != null) {
            this.savePersistentData();
        } else {
            this.fIsDirty = true;
        }
    }

    @Override
    protected void savePersistentData() {
        IDialogSettings settings = this.getPersistentPropertyStore();
        settings.put(XML_LATENCY_VIEW_ANALYSIS_ID_PROPERTY, this.fAnalysisId);
        settings.put(XML_LATENCY_VIEW_LABEL_PROPERTY, this.fLabel);
    }
}

