/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2CallbackPubMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;

public class Ros2TimerCallbackMessageFlowSegment
extends Ros2MessageFlowSegment {
    private final @NonNull Ros2CallbackInstance fCallbackInstance;
    private final @NonNull Ros2TimerObject fTimer;

    public Ros2TimerCallbackMessageFlowSegment(long startTime, long endTime, @NonNull Ros2CallbackInstance callbackInstance, @NonNull Ros2TimerObject timer) {
        super(startTime, endTime, timer.getNodeHandle());
        this.fCallbackInstance = callbackInstance;
        this.fTimer = timer;
    }

    public @NonNull Ros2CallbackInstance getCallbackInstance() {
        return this.fCallbackInstance;
    }

    public @NonNull Ros2TimerObject getTimer() {
        return this.fTimer;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> next = new ArrayList<Ros2MessageFlowSegment>();
        Iterator<@NonNull T> callbackPublicationLinks = Ros2MessagesUtil.getOutgoingCallbackPublicationLinks(info.getMessagesSs(), this.getCallbackInstance().getOwnerHandle(), this.getStartTime(), this.getEndTime()).iterator();
        while (callbackPublicationLinks.hasNext()) {
            Ros2CallbackPublicationInstance callbackPublicationInstance = (Ros2CallbackPublicationInstance)((Object)callbackPublicationLinks.next());
            long time = callbackPublicationInstance.getPublicationTimestamp();
            Ros2TimerObject timerObject = Ros2ObjectsUtil.getTimerObjectFromHandle(info.getObjectsSs(), time, callbackPublicationInstance.getCallbackOwnerHandle());
            Ros2PublisherObject pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(info.getObjectsSs(), time, callbackPublicationInstance.getPublisherHandle());
            if (timerObject == null || pubObject == null) continue;
            next.add(new Ros2CallbackPubMessageFlowSegment(time, time, callbackPublicationInstance, timerObject, pubObject));
        }
        return next;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo info) {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fCallbackInstance, this.fTimer, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ros2TimerCallbackMessageFlowSegment)) {
            return false;
        }
        Ros2TimerCallbackMessageFlowSegment o = (Ros2TimerCallbackMessageFlowSegment)obj;
        if (!this.fCallbackInstance.equals((Object)o.fCallbackInstance)) {
            return false;
        }
        return this.fTimer.equals((Object)o.fTimer);
    }

    @Override
    public String toString() {
        return String.format("Ros2TimerCallbackMessageFlowSegment: %s, callbackInstance=[%s], timer=[%s]", super.toString(), this.fCallbackInstance.toString(), this.fTimer.toString());
    }
}

