/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class ReconcileWorkingCopyOperation
extends JavaModelOperation {
    public static boolean PERF = false;
    public int astLevel;
    public boolean resolveBindings;
    public Map<String, CategorizedProblem[]> problems;
    public int reconcileFlags;
    WorkingCopyOwner workingCopyOwner;
    public org.eclipse.jdt.core.dom.CompilationUnit ast;
    public JavaElementDeltaBuilder deltaBuilder;
    public boolean requestorIsActive;

    public ReconcileWorkingCopyOperation(IJavaElement workingCopy, int astLevel, int reconcileFlags, WorkingCopyOwner workingCopyOwner) {
        super(new IJavaElement[]{workingCopy});
        this.astLevel = astLevel;
        this.reconcileFlags = reconcileFlags;
        this.workingCopyOwner = workingCopyOwner;
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            JavaElementDelta delta;
            this.beginTask(Messages.element_reconciling, 2);
            CompilationUnit workingCopy = this.getWorkingCopy();
            boolean wasConsistent = workingCopy.isConsistent();
            IProblemRequestor problemRequestor = workingCopy.getPerWorkingCopyInfo();
            if (problemRequestor != null) {
                problemRequestor = problemRequestor.getProblemRequestor();
            }
            boolean defaultRequestorIsActive = problemRequestor != null && problemRequestor.isActive();
            IProblemRequestor ownerProblemRequestor = this.workingCopyOwner.getProblemRequestor(workingCopy);
            boolean ownerRequestorIsActive = ownerProblemRequestor != null && ownerProblemRequestor != problemRequestor && ownerProblemRequestor.isActive();
            this.requestorIsActive = defaultRequestorIsActive || ownerRequestorIsActive;
            this.deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
            this.makeConsistent(workingCopy);
            if (!wasConsistent || (this.reconcileFlags & 1) != 0) {
                this.notifyParticipants(workingCopy);
                if (this.ast == null) {
                    this.makeConsistent(workingCopy);
                }
            }
            if (!(this.problems == null || (this.reconcileFlags & 1) == 0 && wasConsistent)) {
                if (defaultRequestorIsActive) {
                    this.reportProblems(workingCopy, problemRequestor);
                }
                if (ownerRequestorIsActive) {
                    this.reportProblems(workingCopy, ownerProblemRequestor);
                }
            }
            if ((delta = this.deltaBuilder.delta) != null) {
                this.addReconcileDelta(workingCopy, delta);
            }
        }
        finally {
            this.done();
        }
    }

    private void reportProblems(CompilationUnit workingCopy, IProblemRequestor problemRequestor) {
        try {
            problemRequestor.beginReporting();
            block3: for (CategorizedProblem[] categorizedProblems : this.problems.values()) {
                if (categorizedProblems == null) continue;
                CategorizedProblem[] categorizedProblemArray = categorizedProblems;
                int n = categorizedProblems.length;
                int n2 = 0;
                while (n2 < n) {
                    CategorizedProblem problem = categorizedProblemArray[n2];
                    if (JavaModelManager.VERBOSE) {
                        JavaModelManager.trace("PROBLEM FOUND while reconciling : " + problem.getMessage());
                    }
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) continue block3;
                    problemRequestor.acceptProblem((IProblem)problem);
                    ++n2;
                }
            }
        }
        finally {
            problemRequestor.endReporting();
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public org.eclipse.jdt.core.dom.CompilationUnit makeConsistent(CompilationUnit workingCopy) throws JavaModelException {
        block30: {
            if (!workingCopy.isConsistent()) {
                if (this.problems == null) {
                    this.problems = new HashMap<String, CategorizedProblem[]>();
                }
                this.resolveBindings = this.requestorIsActive;
                this.ast = workingCopy.makeConsistent(this.astLevel, this.resolveBindings, this.reconcileFlags, this.problems, (IProgressMonitor)this.progressMonitor);
                this.deltaBuilder.buildDeltas();
                if (this.ast != null && this.deltaBuilder.delta != null) {
                    this.deltaBuilder.delta.changedAST(this.ast);
                }
                return this.ast;
            }
            if (this.ast != null) {
                return this.ast;
            }
            try {
                try {
                    JavaModelManager.getJavaModelManager().abortOnMissingSource.set(Boolean.TRUE);
                    CompilationUnit source = workingCopy.cloneCachingContents();
                    if (!JavaProject.hasJavaNature(workingCopy.getJavaProject().getProject()) || (this.reconcileFlags & 1) == 0) break block30;
                    this.resolveBindings = this.requestorIsActive;
                    if (this.problems == null) {
                        this.problems = new HashMap<String, CategorizedProblem[]>();
                    }
                    Map<String, String> options = workingCopy.getJavaProject().getOptions(true);
                    if (CompilationUnit.DOM_BASED_OPERATIONS) {
                        try {
                            ASTParser parser = ASTParser.newParser(this.astLevel > 0 ? this.astLevel : AST.getJLSLatest());
                            parser.setResolveBindings(this.resolveBindings);
                            parser.setCompilerOptions(options);
                            parser.setForceProblemDetection((this.reconcileFlags & 1) != 0);
                            parser.setSource(source);
                            org.eclipse.jdt.core.dom.CompilationUnit newAST = (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST((IProgressMonitor)this.progressMonitor);
                            if ((this.reconcileFlags & 1) != 0 && newAST != null) {
                                newAST.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString());
                            }
                            HashMap<String, List> groupedProblems = new HashMap<String, List>();
                            IProblem[] iProblemArray = newAST.getProblems();
                            int n = iProblemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IProblem problem = iProblemArray[n2];
                                if (problem instanceof CategorizedProblem) {
                                    CategorizedProblem categorizedProblem = (CategorizedProblem)problem;
                                    groupedProblems.computeIfAbsent(categorizedProblem.getMarkerType(), key -> new ArrayList()).add(categorizedProblem);
                                }
                                ++n2;
                            }
                            for (Map.Entry entry : groupedProblems.entrySet()) {
                                this.problems.put((String)entry.getKey(), (CategorizedProblem[])((List)entry.getValue()).toArray(CategorizedProblem[]::new));
                            }
                            if (this.astLevel != 0) {
                                this.ast = newAST;
                            }
                        }
                        catch (AbortCompilationUnit ex) {
                            CategorizedProblem problem = ex.problem;
                            if (problem == null && ex.exception instanceof IOException) {
                                IOException ioEx = (IOException)ex.exception;
                                String path = source.getPath().toString();
                                String exceptionTrace = ioEx.getClass().getName() + ":" + ioEx.getMessage();
                                problem = new DefaultProblemFactory().createProblem(path.toCharArray(), 536871614, new String[]{path, exceptionTrace}, new String[]{path, exceptionTrace}, 131, 0, 0, 1, 0);
                            }
                            this.problems.put(Integer.toString(10), new CategorizedProblem[]{problem});
                        }
                    } else {
                        CompilationUnitDeclaration unit = null;
                        try {
                            unit = CompilationUnitProblemFinder.process(source, this.workingCopyOwner, this.problems, this.astLevel != 0, this.reconcileFlags, (IProgressMonitor)this.progressMonitor);
                            if (this.progressMonitor != null) {
                                this.progressMonitor.worked(1);
                            }
                            if (this.astLevel != 0 && unit != null) {
                                this.ast = AST.convertCompilationUnit(this.astLevel, unit, options, this.resolveBindings, source, this.reconcileFlags, (IProgressMonitor)this.progressMonitor);
                            }
                        }
                        finally {
                            if (unit != null) {
                                unit.cleanUp();
                            }
                        }
                    }
                    if (this.ast != null) {
                        if (this.deltaBuilder.delta == null) {
                            this.deltaBuilder.delta = new JavaElementDelta(workingCopy);
                        }
                        this.deltaBuilder.delta.changedAST(this.ast);
                    }
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
                catch (JavaModelException e) {
                    if (JavaProject.hasJavaNature(workingCopy.getJavaProject().getProject())) {
                        throw e;
                    }
                    JavaModelManager.getJavaModelManager().abortOnMissingSource.remove();
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().abortOnMissingSource.remove();
            }
        }
        return this.ast;
    }

    private void notifyParticipants(CompilationUnit workingCopy) {
        JavaProject javaProject = this.getWorkingCopy().getJavaProject();
        CompilationParticipant[] participants = JavaModelManager.getJavaModelManager().compilationParticipants.getCompilationParticipants(javaProject);
        if (participants == null) {
            return;
        }
        final ReconcileContext context = new ReconcileContext(this, workingCopy);
        CompilationParticipant[] compilationParticipantArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            final CompilationParticipant participant = compilationParticipantArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (exception instanceof Error) {
                        throw (Error)exception;
                    }
                    if (exception instanceof OperationCanceledException) {
                        throw (OperationCanceledException)exception;
                    }
                    if (exception instanceof UnsupportedOperationException) {
                        Util.log(exception, "Reconcile participant attempted to modify the buffer of the working copy being reconciled");
                    } else {
                        Util.log(exception, "Exception occurred in reconcile participant");
                    }
                }

                public void run() throws Exception {
                    participant.reconcile(context);
                }
            });
            ++n2;
        }
    }

    @Override
    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        CompilationUnit workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new JavaModelStatus(969, workingCopy);
        }
        return status;
    }
}

