/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Arrays;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PackageBinding;
import org.eclipse.jdt.core.dom.TypeBinding;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

class ModuleBinding
implements IModuleBinding {
    protected static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private final String name;
    private volatile String key;
    private boolean isOpen = false;
    private final org.eclipse.jdt.internal.compiler.lookup.ModuleBinding binding;
    protected BindingResolver resolver;
    private IAnnotationBinding[] annotations;
    private IModuleBinding[] requiredModules;
    private IModuleBinding[] requiredTransitiveModules;
    private IPackageBinding[] exports;
    private IPackageBinding[] opens;
    private ITypeBinding[] uses;
    private ITypeBinding[] services;

    ModuleBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.ModuleBinding binding) {
        this.name = null;
        this.resolver = resolver;
        this.binding = binding;
        this.isOpen = binding.isOpen();
    }

    @Override
    public IAnnotationBinding[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotationBindings(this.binding.getAnnotations());
        }
        return this.annotations;
    }

    private IAnnotationBinding[] resolveAnnotationBindings(org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] internalAnnotations) {
        int length;
        int n = length = internalAnnotations == null ? 0 : internalAnnotations.length;
        if (length != 0) {
            IAnnotationBinding[] tempAnnotations = new IAnnotationBinding[length];
            int convertedAnnotationCount = 0;
            int i = 0;
            while (i < length) {
                org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding internalAnnotation = internalAnnotations[i];
                if (internalAnnotation == null) break;
                IAnnotationBinding annotationInstance = this.resolver.getAnnotationInstance(internalAnnotation);
                if (annotationInstance != null) {
                    tempAnnotations[convertedAnnotationCount++] = annotationInstance;
                }
                ++i;
            }
            if (convertedAnnotationCount != length) {
                if (convertedAnnotationCount == 0) {
                    this.annotations = AnnotationBinding.NoAnnotations;
                    return AnnotationBinding.NoAnnotations;
                }
                IAnnotationBinding[] iAnnotationBindingArray = tempAnnotations;
                tempAnnotations = new IAnnotationBinding[convertedAnnotationCount];
                System.arraycopy(iAnnotationBindingArray, 0, tempAnnotations, 0, convertedAnnotationCount);
            }
            return tempAnnotations;
        }
        return AnnotationBinding.NoAnnotations;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            char[] tmp = this.binding.moduleName;
            return tmp != null && tmp.length != 0 ? new String(tmp) : Util.EMPTY_STRING;
        }
        return this.name;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isRecovered() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public IJavaElement getJavaElement() {
        INameEnvironment nameEnvironment = this.binding.environment.nameEnvironment;
        if (!(nameEnvironment instanceof SearchableEnvironment)) {
            return null;
        }
        NameLookup nameLookup = ((SearchableEnvironment)nameEnvironment).nameLookup;
        if (nameLookup == null) {
            return null;
        }
        NameLookup.Answer answer = nameLookup.findModule(this.getName().toCharArray());
        if (answer == null) {
            return null;
        }
        return answer.module;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            char[] k = this.binding.computeUniqueKey();
            this.key = k == null || k == CharOperation.NO_CHAR ? Util.EMPTY_STRING : new String(k);
        }
        return this.key;
    }

    @Override
    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ModuleBinding)) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.ModuleBinding otherBinding = ((ModuleBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public IModuleBinding[] getRequiredModules() {
        if (this.requiredModules != null) {
            return this.requiredModules;
        }
        org.eclipse.jdt.internal.compiler.lookup.ModuleBinding[] reqs = this.binding.getRequires();
        IModuleBinding[] result = new IModuleBinding[reqs != null ? reqs.length : 0];
        int i = 0;
        int l = result.length;
        while (i < l) {
            org.eclipse.jdt.internal.compiler.lookup.ModuleBinding req = reqs[i];
            result[i] = req != null ? this.resolver.getModuleBinding(req) : null;
            ++i;
        }
        this.requiredModules = result;
        return result;
    }

    @Override
    public IModuleBinding[] getRequiredTransitiveModules() {
        if (this.requiredTransitiveModules != null) {
            return this.requiredTransitiveModules;
        }
        org.eclipse.jdt.internal.compiler.lookup.ModuleBinding[] reqs = this.binding.getRequiresTransitive();
        IModuleBinding[] result = new IModuleBinding[reqs != null ? reqs.length : 0];
        int i = 0;
        int l = result.length;
        while (i < l) {
            org.eclipse.jdt.internal.compiler.lookup.ModuleBinding req = reqs[i];
            result[i] = req != null ? this.resolver.getModuleBinding(req) : null;
            ++i;
        }
        this.requiredTransitiveModules = result;
        return result;
    }

    @Override
    public IPackageBinding[] getExportedPackages() {
        if (this.exports == null) {
            PlainPackageBinding[] compilerExports = this.binding.getExports();
            this.exports = (IPackageBinding[])Arrays.stream(compilerExports).map(e -> this.resolver.getPackageBinding((org.eclipse.jdt.internal.compiler.lookup.PackageBinding)e)).toArray(IPackageBinding[]::new);
        }
        return this.exports;
    }

    @Override
    public String[] getExportedTo(IPackageBinding packageBinding) {
        return this.binding.getExportRestrictions(((PackageBinding)packageBinding).getCompilerBinding());
    }

    @Override
    public IPackageBinding[] getOpenedPackages() {
        if (this.opens == null) {
            PlainPackageBinding[] compilerOpens = this.binding.getOpens();
            this.opens = (IPackageBinding[])Arrays.stream(compilerOpens).map(o -> this.resolver.getPackageBinding((org.eclipse.jdt.internal.compiler.lookup.PackageBinding)o)).toArray(IPackageBinding[]::new);
        }
        return this.opens;
    }

    @Override
    public String[] getOpenedTo(IPackageBinding packageBinding) {
        return this.binding.getOpenRestrictions(((PackageBinding)packageBinding).getCompilerBinding());
    }

    private ITypeBinding[] getTypes(org.eclipse.jdt.internal.compiler.lookup.TypeBinding[] types) {
        int length = types == null ? 0 : types.length;
        ITypeBinding[] result = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            result[i] = (TypeBinding)this.resolver.getTypeBinding(types[i]);
            ++i;
        }
        return result;
    }

    @Override
    public ITypeBinding[] getUses() {
        if (this.uses == null) {
            this.uses = this.getTypes(this.binding.getUses());
        }
        return this.uses;
    }

    @Override
    public ITypeBinding[] getServices() {
        if (this.services == null) {
            this.services = this.getTypes(this.binding.getServices());
        }
        return this.services;
    }

    @Override
    public ITypeBinding[] getImplementations(ITypeBinding service) {
        return this.getTypes(this.binding.getImplementations(((TypeBinding)service).binding));
    }

    @Override
    public String toString() {
        return this.binding.toString();
    }
}

