/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.ui;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.incubator.internal.inandout.ui.InAndOutConfigDialog;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfViewsElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class InAndOutHandler
extends AbstractHandler {
    private @Nullable TmfAnalysisElement fAnalysis;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fAnalysis = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfAnalysisElement) {
            this.fAnalysis = (TmfAnalysisElement)element;
        }
        if (this.fAnalysis != null) {
            return Objects.equals(this.fAnalysis.getAnalysisId(), "org.eclipse.tracecompass.incubator.inandout.analysis");
        }
        return false;
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        Shell activeShellChecked = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        TmfAnalysisElement analysis = this.fAnalysis;
        if (analysis != null && activeShellChecked != null) {
            TmfViewsElement parent = analysis.getParent();
            TmfCommonProjectElement traceElement = parent.getParent();
            Object elementPath = traceElement.getElementPath();
            if (traceElement instanceof TmfExperimentElement) {
                elementPath = (String)elementPath + ((TmfExperimentElement)traceElement).getSuffix();
            }
            IFolder traceSupplementaryFolder = analysis.getTraceSupplementaryFolder((String)elementPath);
            URI rawLocationURI = traceSupplementaryFolder.getRawLocationURI();
            String osString = rawLocationURI.getRawPath();
            InAndOutConfigDialog dialog = new InAndOutConfigDialog(activeShellChecked, new File(osString), traceElement.getTrace());
            dialog.open();
            if (dialog.isChanged()) {
                traceElement.closeEditors();
            }
            parent.refresh();
            if (dialog.isChanged()) {
                TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)traceElement);
            }
        }
        return null;
    }
}

