/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;

public class RecentlyUsedFilters {
    private final Preferences fPreferences;
    private final int fSize;
    private final List<String> fFilters;

    public RecentlyUsedFilters(int size, String listName) {
        this.fSize = size;
        this.fPreferences = Preferences.userRoot().node(listName);
        this.fFilters = new ArrayList<String>(this.fSize);
        this.loadFilters();
    }

    public void addFilter(String filter) {
        if (this.fFilters.size() >= this.fSize) {
            this.fFilters.remove(0);
        }
        this.fFilters.add(filter);
        this.saveFilters();
    }

    public List<String> getRecentlyFilters() {
        ArrayList<String> filters = new ArrayList<String>(this.fSize);
        int i = this.fFilters.size() - 1;
        while (i >= 0) {
            filters.add(this.fFilters.get(i));
            --i;
        }
        return Collections.unmodifiableList(filters);
    }

    public void clearFilters() {
        int i = 0;
        while (i < this.fFilters.size()) {
            this.fPreferences.remove("filter" + i);
            ++i;
        }
        this.fFilters.clear();
    }

    private void loadFilters() {
        int i = 0;
        while (i < this.fSize) {
            String filter = this.fPreferences.get("filter" + i, null);
            if (filter != null) {
                this.fFilters.add(filter);
            }
            ++i;
        }
    }

    private void saveFilters() {
        int i = 0;
        while (i < this.fFilters.size()) {
            this.fPreferences.put("filter" + i, this.fFilters.get(i));
            ++i;
        }
    }
}

