/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.throughput.analysis;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.analysis.IDpdkEventHandler;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.analysis.DpdkEthdevEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DpdkEthdevThroughputEventHandler
implements IDpdkEventHandler {
    private static final String ETH_NIC_PORTS = Objects.requireNonNull("Ports");
    private static final String RX_Q = Objects.requireNonNull("rx_qs");
    private static final String TX_Q = Objects.requireNonNull("tx_qs");
    private static final String PKT_NB = Objects.requireNonNull("pkt_cnt");
    private static final String PKT_NB_P = Objects.requireNonNull("pkt_cnt_p");
    private static final String PKT_SIZE_P = Objects.requireNonNull("pkt_size_p");
    private final DpdkEthdevEventLayout fLayout;

    DpdkEthdevThroughputEventHandler(DpdkEthdevEventLayout layout) {
        this.fLayout = layout;
    }

    public void updateCounts(ITmfStateSystemBuilder ssb, Integer portId, Integer queueId, String queueCategoryAttribute, boolean isProfileEvent, Integer nbPkts, @Nullable Integer size, long timestamp) {
        int portQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{ETH_NIC_PORTS, portId.toString()});
        int queuesQuark = ssb.getQuarkRelativeAndAdd(portQuark, new String[]{queueCategoryAttribute});
        int queueQuark = ssb.getQuarkRelativeAndAdd(queuesQuark, new String[]{queueId.toString()});
        try {
            if (isProfileEvent) {
                int pktSizeQuark = ssb.getQuarkRelativeAndAdd(queueQuark, new String[]{PKT_SIZE_P});
                StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)timestamp, (int)pktSizeQuark, (long)Objects.requireNonNull(size).intValue());
                int pktNumberQuark = ssb.getQuarkRelativeAndAdd(queueQuark, new String[]{PKT_NB_P});
                StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)timestamp, (int)pktNumberQuark, (long)nbPkts.intValue());
            } else {
                int pktNumberQuark = ssb.getQuarkRelativeAndAdd(queueQuark, new String[]{PKT_NB});
                StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)timestamp, (int)pktNumberQuark, (long)nbPkts.intValue());
            }
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logWarning("Problem accessing the state of a port queue (Quark = " + queueQuark + ")", (Throwable)e);
        }
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        String eventName = event.getName();
        long timestamp = event.getTimestamp().getValue();
        Integer portId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldPortId()});
        if (eventName.equals(this.fLayout.eventEthdevRxBurstNonEmpty()) || eventName.equals(this.fLayout.eventProfileEthdevRxBurst())) {
            this.handleBurstEvent(ssb, event, Objects.requireNonNull(portId), RX_Q, timestamp);
        } else if (eventName.equals(this.fLayout.eventEthdevTxBurst()) || eventName.equals(this.fLayout.eventProfileEthdevTxBurst())) {
            this.handleBurstEvent(ssb, event, Objects.requireNonNull(portId), TX_Q, timestamp);
        } else {
            Activator.getInstance().logError("Unknown event (" + eventName + ")");
        }
    }

    private void handleBurstEvent(ITmfStateSystemBuilder ssb, ITmfEvent event, Integer portId, String queueCategory, long timestamp) {
        boolean isProfileEvent;
        Integer size = null;
        boolean isRxEvent = queueCategory.equals(RX_Q);
        Integer nbPkts = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{isRxEvent ? this.fLayout.fieldNbRxPkts() : this.fLayout.fieldNbPkts()});
        boolean bl = isProfileEvent = event.getName().equals(this.fLayout.eventProfileEthdevTxBurst()) || event.getName().equals(this.fLayout.eventProfileEthdevRxBurst());
        if (isProfileEvent) {
            size = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldSize()});
            if (!isRxEvent) {
                nbPkts = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldNbTxPkts()});
            }
        }
        Integer queueId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldQueueId()});
        this.updateCounts(ssb, portId, Objects.requireNonNull(queueId), queueCategory, isProfileEvent, Objects.requireNonNull(nbPkts), size, timestamp);
    }
}

