/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.filter;

import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.sse.ui.quickoutline.StringMatcher;

public class OutlineNamePatternFilter
extends ViewerFilter {
    private String[] fPatterns;
    private StringMatcher[] fMatchers;

    public String[] getPatterns() {
        return this.fPatterns;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IBaseLabelProvider labelProvider;
        if (this.getPatterns().length == 0) {
            return true;
        }
        String matchName = null;
        if (viewer instanceof ContentViewer && (labelProvider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            matchName = ((ILabelProvider)labelProvider).getText(element);
        }
        if (matchName != null && matchName.length() > 0) {
            String[] fPatterns = this.getPatterns();
            int i = 0;
            while (i < fPatterns.length) {
                if (new StringMatcher(fPatterns[i], true, false).match(matchName)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] newPatterns) {
        this.fPatterns = newPatterns;
        this.fMatchers = new StringMatcher[newPatterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            this.fMatchers[i] = new StringMatcher(newPatterns[i], true, false);
            ++i;
        }
    }
}

