/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.base;

import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

@Deprecated(since="0.10.0", forRemoval=true)
public class EdgeStateValue
extends CustomStateValue {
    public static final byte CUSTOM_TYPE_ID = 22;
    public static final CustomStateValue.CustomStateValueFactory EDGE_STATE_VALUE_FACTORY = b -> new EdgeStateValue(b.getInt(), EdgeStateValue.readHostThread(b), EdgeStateValue.readHostThread(b));
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final Comparator<HostThread> HOST_COMPARATOR = Comparator.comparing(HostThread::getHost).thenComparingInt(HostThread::getTid);
    private static final Comparator<EdgeStateValue> COMPARATOR = Comparator.comparing(EdgeStateValue::getSource, HOST_COMPARATOR).thenComparing(EdgeStateValue::getDestination, HOST_COMPARATOR);
    private final int fId;
    private final HostThread fSrc;
    private final HostThread fDst;

    private static final HostThread readHostThread(ISafeByteBufferReader buffer) {
        String host = buffer.getString();
        int tid = buffer.getInt();
        return new HostThread(host, Integer.valueOf(tid));
    }

    public EdgeStateValue(int id, HostThread src, HostThread dst) {
        this.fId = id;
        this.fSrc = src;
        this.fDst = dst;
    }

    public int getId() {
        return this.fId;
    }

    public HostThread getSource() {
        return this.fSrc;
    }

    public HostThread getDestination() {
        return this.fDst;
    }

    public int compareTo(@NonNull ITmfStateValue o) {
        if (o instanceof EdgeStateValue) {
            return COMPARATOR.compare(this, (EdgeStateValue)o);
        }
        return 1;
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)22;
    }

    protected void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putInt(this.fId);
        EdgeStateValue.serializeHostThread(this.fSrc, buffer);
        EdgeStateValue.serializeHostThread(this.fDst, buffer);
    }

    private static void serializeHostThread(HostThread hostThread, ISafeByteBufferWriter buffer) {
        buffer.putString(hostThread.getHost());
        buffer.putInt(hostThread.getTid().intValue());
    }

    protected int getSerializedValueSize() {
        int size = 12;
        size += this.fSrc.getHost().getBytes(CHARSET).length + 3;
        return size += this.fDst.getHost().getBytes(CHARSET).length + 3;
    }

    public String toString() {
        return "Edge: id=" + this.fId + ", src=" + String.valueOf(this.fSrc) + ", dst=" + String.valueOf(this.fDst);
    }

    public int hashCode() {
        return Objects.hash(this.fId, this.fSrc, this.fDst);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof EdgeStateValue)) {
            return false;
        }
        EdgeStateValue other = (EdgeStateValue)((Object)obj);
        return this.fId == other.fId && Objects.equals(this.fSrc, other.fSrc) && Objects.equals(this.fDst, other.fDst);
    }
}

