/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4.IPv4Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.EthertypeHelper;

public class EthernetIIPacket
extends Packet {
    private final @Nullable Packet fChildPacket;
    private final @Nullable ByteBuffer fPayload;
    private final byte[] fSourceMacAddress;
    private final byte[] fDestinationMacAddress;
    private final int fType;
    private @Nullable EthernetIIEndpoint fSourceEndpoint;
    private @Nullable EthernetIIEndpoint fDestinationEndpoint;
    private @Nullable Map<String, String> fFields;

    public EthernetIIPacket(PcapFile file, @Nullable Packet parent, ByteBuffer packet) throws BadPacketException {
        super(file, parent, PcapProtocol.ETHERNET_II);
        if (packet.limit() <= 14) {
            throw new BadPacketException("An Ethernet II packet can't be smaller than 14 bytes.");
        }
        this.fSourceEndpoint = null;
        this.fDestinationEndpoint = null;
        this.fFields = null;
        this.fDestinationMacAddress = new byte[6];
        this.fSourceMacAddress = new byte[6];
        packet.order(ByteOrder.BIG_ENDIAN);
        packet.position(0);
        packet.get(this.fDestinationMacAddress);
        packet.get(this.fSourceMacAddress);
        this.fType = ConversionHelper.unsignedShortToInt(packet.getShort());
        if (packet.remaining() > 0) {
            ByteBuffer payload = packet.slice();
            payload.order(ByteOrder.BIG_ENDIAN);
            this.fPayload = payload;
        } else {
            this.fPayload = null;
        }
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    public byte[] getSourceMacAddress() {
        return (byte[])NonNullUtils.checkNotNull((Object)Arrays.copyOf(this.fSourceMacAddress, this.fSourceMacAddress.length));
    }

    public byte[] getDestinationMacAddress() {
        return (byte[])NonNullUtils.checkNotNull((Object)Arrays.copyOf(this.fDestinationMacAddress, this.fDestinationMacAddress.length));
    }

    public int getEthertype() {
        return this.fType;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        switch (this.fType) {
            case 2048: {
                return new IPv4Packet(this.getPcapFile(), (Packet)this, payload);
            }
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    public String toString() {
        String string = String.valueOf(this.getProtocol().getName()) + ", Source: " + ConversionHelper.toMacAddress(this.fSourceMacAddress) + ", Destination: " + ConversionHelper.toMacAddress(this.fDestinationMacAddress) + ", Type: " + EthertypeHelper.toEtherType(this.fType) + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return String.valueOf(string) + child.toString();
        }
        return string;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public EthernetIIEndpoint getSourceEndpoint() {
        @Nullable EthernetIIEndpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new EthernetIIEndpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public EthernetIIEndpoint getDestinationEndpoint() {
        @Nullable EthernetIIEndpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new EthernetIIEndpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"Source MAC Address", (Object)ConversionHelper.toMacAddress(this.fSourceMacAddress));
            builder.put((Object)"Destination MAC Address", (Object)ConversionHelper.toMacAddress(this.fDestinationMacAddress));
            builder.put((Object)"Ethertype", (Object)String.valueOf(EthertypeHelper.toEtherType(this.fType)));
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Src: " + ConversionHelper.toMacAddress(this.fSourceMacAddress) + " , Dst: " + ConversionHelper.toMacAddress(this.fDestinationMacAddress);
    }

    @Override
    protected String getSignificationString() {
        return "Source MAC: " + ConversionHelper.toMacAddress(this.fSourceMacAddress) + " , Destination MAC: " + ConversionHelper.toMacAddress(this.fDestinationMacAddress);
    }

    @Override
    public int hashCode() {
        int result = 1;
        Packet child = this.fChildPacket;
        result = child != null ? 31 * result + child.hashCode() : (result *= 31);
        result = 31 * result + Arrays.hashCode(this.fDestinationMacAddress);
        if (child == null) {
            result = 31 * result + EthernetIIPacket.payloadHashCode(this.fPayload);
        }
        result = 31 * result + Arrays.hashCode(this.fSourceMacAddress);
        result = 31 * result + this.fType;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EthernetIIPacket other = (EthernetIIPacket)obj;
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        if (!Arrays.equals(this.fDestinationMacAddress, other.fDestinationMacAddress)) {
            return false;
        }
        if (this.fChildPacket == null && !EthernetIIPacket.payloadEquals(this.fPayload, other.fPayload)) {
            return false;
        }
        if (!Arrays.equals(this.fSourceMacAddress, other.fSourceMacAddress)) {
            return false;
        }
        return this.fType == other.fType;
    }
}

