/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.functiondensity;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class FunctionTableViewer
extends AbstractSegmentStoreTableViewer {
    private final String fAnalysisId;

    public FunctionTableViewer(@NonNull TableViewer tableViewer, String analysisId) {
        super(tableViewer);
        this.fAnalysisId = analysisId;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable ISegmentStoreProvider getSegmentStoreProvider(@NonNull ITmfTrace trace) {
        IAnalysisModule module = trace.getAnalysisModule(this.fAnalysisId);
        if (!(module instanceof ISegmentStoreProvider)) {
            @NonNull Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
            Optional<@NonNull ISegmentStoreProvider> providers = StreamSupport.stream(modules.spliterator(), false).filter(mod -> mod instanceof IAnalysisModule && Objects.equals(this.fAnalysisId, ((IAnalysisModule)mod).getId())).findFirst();
            if (providers.isPresent()) {
                return providers.get();
            }
            return null;
        }
        return (ISegmentStoreProvider)module;
    }
}

