/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import junit.framework.TestCase;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.collection.Versions;
import org.eclipse.php.composer.api.entities.Version;
import org.eclipse.php.composer.api.packages.PackagistDownloader;
import org.junit.Test;

public class VersionTest
extends TestCase {
    @Test
    public void testParser() {
        Version v = new Version("1.2.3");
        VersionTest.assertEquals((String)"1", (String)v.getMajor());
        VersionTest.assertEquals((String)"2", (String)v.getMinor());
        VersionTest.assertEquals((String)"3", (String)v.getFix());
        v.setVersion(">1.2.3-rc1@beta");
        VersionTest.assertEquals((String)">", (String)v.getConstraint());
        VersionTest.assertEquals((String)"1", (String)v.getSuffix());
        VersionTest.assertEquals((String)"beta", (String)v.getStabilityModifier());
        VersionTest.assertEquals((String)"RC", (String)v.getStability());
        v.setVersion("dev-master");
        VersionTest.assertEquals((String)"master", (String)v.getMajor());
        VersionTest.assertEquals((int)0, (int)v.getDevPosition());
        v.setVersion("v2.0.17");
        VersionTest.assertEquals((String)"2", (String)v.getMajor());
        VersionTest.assertEquals((String)"v", (String)v.getPrefix());
    }

    @Test
    public void testBuilder() {
        Version v = new Version();
        v.setMajor("1");
        v.setMinor("2");
        v.setFix("4");
        v.setBuild("5648");
        v.setConstraint(">");
        v.setStabilityModifier("beta");
        v.setStability("alpha");
        v.setSuffix("2");
        String version = v.toString();
        VersionTest.assertEquals((String)">1.2.4.5648-alpha2@beta", (String)version);
        Version t = new Version(version);
        VersionTest.assertEquals((String)">", (String)t.getConstraint());
        VersionTest.assertEquals((String)"1", (String)t.getMajor());
        VersionTest.assertEquals((String)"2", (String)t.getMinor());
        VersionTest.assertEquals((String)"4", (String)t.getFix());
        VersionTest.assertEquals((String)"5648", (String)t.getBuild());
        VersionTest.assertEquals((String)"2", (String)t.getSuffix());
        VersionTest.assertEquals((String)"alpha", (String)t.getStability());
        VersionTest.assertEquals((String)"beta", (String)t.getStabilityModifier());
        v = new Version();
        v.setStability("dev");
        v.setMajor("master");
        v.setDevPosition(0);
        VersionTest.assertEquals((String)"dev-master", (String)v.toString());
        v = new Version();
        v.setMajor("2");
        v.setPrefix("v");
        VersionTest.assertEquals((String)"v2", (String)v.toString());
    }

    @Test
    public void testSymfony() {
        try {
            PackagistDownloader downloader = new PackagistDownloader();
            RepositoryPackage pkg = downloader.loadPackage("symfony/symfony");
            Versions versions = pkg.getVersions();
            VersionTest.assertNotNull((Object)versions.getMajors());
            VersionTest.assertTrue((Integer.parseInt(versions.getRecentMajor()) >= 2 ? 1 : 0) != 0);
            VersionTest.assertTrue((Integer.parseInt(versions.getRecentMinor("2")) >= 2 ? 1 : 0) != 0);
            VersionTest.assertNull((Object)versions.getRecentMinor(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            VersionTest.fail();
        }
    }

    @Test
    public void testComparison() {
        Version v1 = new Version("2.0.10");
        Version v2 = new Version("2.0.11");
        VersionTest.assertEquals((int)-1, (int)v1.compareTo(v2));
        v2.setVersion("2.0.7");
        VersionTest.assertEquals((int)1, (int)v1.compareTo(v2));
        v2.setVersion("2.0.10-beta2");
        VersionTest.assertEquals((int)1, (int)v1.compareTo(v2));
        v1.setVersion("2.0.10-beta3");
        VersionTest.assertEquals((int)1, (int)v1.compareTo(v2));
        v2.setVersion("2.0.x-dev");
        VersionTest.assertEquals((int)-1, (int)v1.compareTo(v2));
    }
}

