/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.parser.antlr.DotRecordLabelParser;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.recordlabel.Field;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.zest.fx.parts.ZestFxRootPart;
import org.eclipse.xtext.parser.IParseResult;

class DotRecordBasedJavaFxNode {
    private static Insets TEXT_MARGINS = new Insets(1.5, 7.0, 1.5, 7.0);
    private final LabelNode root;
    private String zestNodeLabelCssStyle;
    private String lineCssStyle;

    public DotRecordBasedJavaFxNode(String dotLabel, Rankdir rankdir, String zestNodeLabelCssStyle, String lineCssStyle) {
        this.root = this.rootNodeConstructor(rankdir).get().rootNode();
        this.zestNodeLabelCssStyle = zestNodeLabelCssStyle;
        this.lineCssStyle = lineCssStyle;
        this.addToFx(this.parseLabel(dotLabel), this.root);
    }

    public Pane getFxElement() {
        return this.root.getFxElement();
    }

    public Bounds getBounds() {
        Group fxElement = new Group(new Node[]{this.getFxElement()});
        Scene scene = new Scene((Parent)fxElement);
        scene.getStylesheets().add((Object)ZestFxRootPart.STYLES_CSS_FILE);
        fxElement.applyCss();
        fxElement.layout();
        return fxElement.getBoundsInParent();
    }

    private EObject parseLabel(String dotLabel) {
        Injector recordLabelInjector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotRecordLabel");
        DotRecordLabelParser parser = (DotRecordLabelParser)recordLabelInjector.getInstance(DotRecordLabelParser.class);
        IParseResult result = parser.parse((Reader)new StringReader(dotLabel != null ? dotLabel : new String()));
        return result.getRootASTElement();
    }

    private void addToFx(EObject parsedObject, LabelNode treeNode) {
        for (EObject child : parsedObject.eContents()) {
            if (child instanceof Field && ((Field)child).getLabel() != null) {
                this.addToFx((EObject)((Field)child).getLabel(), treeNode.childNode());
                continue;
            }
            if (!(child instanceof Field) || ((Field)child).getFieldID() == null) continue;
            treeNode.addText(((Field)child).getFieldID().getName(), this.zestNodeLabelCssStyle);
        }
    }

    private Supplier<LabelNode> rootNodeConstructor(Rankdir rankdir) {
        switch (rankdir != null ? rankdir : Rankdir.TB) {
            case LR: 
            case RL: {
                return () -> VerticalLabelNode.new(this);
            }
        }
        return () -> HorizontalLabelNode.new(this);
    }

    private class HorizontalLabelNode
    extends LabelNode {
        private HBox fxElement;

        public HorizontalLabelNode() {
            this.fxElement = new HBox();
            this.fxElement.setAlignment(Pos.CENTER);
        }

        public HBox getFxElement() {
            return this.fxElement;
        }

        @Override
        public LabelNode provideChildNode() {
            return new VerticalLabelNode();
        }

        @Override
        protected Orientation getOrientation() {
            return Orientation.HORIZONTAL;
        }

        @Override
        protected void setMargin(Node text, Insets insets) {
            HBox.setMargin((Node)text, (Insets)insets);
        }

        @Override
        protected void setGrow(Node node) {
            HBox.setHgrow((Node)node, (Priority)Priority.ALWAYS);
        }
    }

    private abstract class LabelNode {
        private boolean firstField = true;

        private LabelNode() {
        }

        public abstract Pane getFxElement();

        public abstract LabelNode provideChildNode();

        public LabelNode childNode() {
            LabelNode child = this.provideChildNode();
            this.addRotatedLabel(child);
            return child;
        }

        public LabelNode rootNode() {
            this.getFxElement().getStyleClass().addAll((Object[])new String[]{"node"});
            return this;
        }

        public void addText(String string, String zestNodeLabelCssStyle) {
            this.separatorUnlessFirstField();
            TextHelper text = new TextHelper(string, zestNodeLabelCssStyle);
            this.setMargin(text.getFxElement(), TEXT_MARGINS);
            this.setGrow(text.getFxElement());
            this.getFxElement().getChildren().add((Object)text.getFxElement());
        }

        public void addRotatedLabel(LabelNode label) {
            this.separatorUnlessFirstField();
            Pane labelNode = label.getFxElement();
            this.setGrow((Node)labelNode);
            this.getFxElement().getChildren().add((Object)labelNode);
        }

        private void separatorUnlessFirstField() {
            if (!this.firstField) {
                this.addLine();
            } else {
                this.firstField = false;
            }
        }

        private void addLine() {
            this.getFxElement().getChildren().add((Object)new RecordBasedLabelLine(this.getOrientation()));
        }

        protected abstract Orientation getOrientation();

        protected abstract void setMargin(Node var1, Insets var2);

        protected abstract void setGrow(Node var1);
    }

    private class RecordBasedLabelLine
    extends GeometryNode<Line> {
        private final Line line;

        public RecordBasedLabelLine(Orientation orientation) {
            switch (orientation != null ? orientation : Orientation.HORIZONTAL) {
                case VERTICAL: {
                    this.line = new Line(0.0, 0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    this.line = new Line(0.0, 0.0, 0.0, 1.0);
                }
            }
            this.setGeometry((IGeometry)this.line);
            if (DotRecordBasedJavaFxNode.this.lineCssStyle != null && !DotRecordBasedJavaFxNode.this.lineCssStyle.isEmpty()) {
                this.setStyle(DotRecordBasedJavaFxNode.this.lineCssStyle);
            }
        }
    }

    private static class TextHelper {
        private final Pane fxElement;
        private final String style;

        public TextHelper(String string, String style) {
            this.style = style;
            this.fxElement = this.fxElementFromString(this.unescapeString(string));
        }

        public Node getFxElement() {
            return this.fxElement;
        }

        private Pane fxElementFromString(String string) {
            VBox textContainer = new VBox();
            textContainer.setAlignment(Pos.CENTER);
            this.makeLines(string).forEach(line -> {
                boolean bl = textContainer.getChildren().add((Object)line.getFxElement(this.style));
            });
            return textContainer;
        }

        private String unescapeString(String string) {
            if (string == null || string.length() == 0) {
                string = " ";
            }
            string = StringEscapeUtils.unescapeHtml((String)string);
            string = string.replaceAll("\t\\s+", "\t").replaceAll(" \\s+", " ").replaceAll("[^ \t&&\\s]+", "");
            return string.replaceAll("\\\\([^lrn])", "$1");
        }

        private List<TextLine> makeLines(String string) {
            ArrayList<TextLine> lines = new ArrayList<TextLine>();
            while (string != null) {
                TextLine line = new TextLine();
                string = line.consumeFirstLineOf(string);
                lines.add(line);
            }
            return lines;
        }
    }

    private static class TextLine {
        private Pos pos;
        private String line;

        private TextLine() {
        }

        public String consumeFirstLineOf(String lines) {
            int indexLast = 0;
            block7: do {
                try {
                    int indexNew = lines.indexOf(92, indexLast);
                    if (indexNew < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    switch (lines.charAt(indexNew + 1)) {
                        case 'n': {
                            this.pos = Pos.CENTER;
                            break;
                        }
                        case 'l': {
                            this.pos = Pos.CENTER_LEFT;
                            break;
                        }
                        case 'r': {
                            this.pos = Pos.CENTER_RIGHT;
                            break;
                        }
                        default: {
                            indexLast = indexNew + 1;
                            continue block7;
                        }
                    }
                    this.line = lines.substring(0, indexNew);
                    if (lines.length() <= indexNew + 2) break;
                    return lines.substring(indexNew + 2);
                }
                catch (IndexOutOfBoundsException e) {
                    this.line = lines;
                    break;
                }
            } while (indexLast >= 0);
            return null;
        }

        public Pane getFxElement(String style) {
            if (this.line == null) {
                throw new RuntimeException("Unable to get FXElement: TextLine not initialized.");
            }
            HBox alignmentBox = new HBox();
            alignmentBox.setAlignment(this.pos != null ? this.pos : Pos.CENTER);
            Text text = new Text(this.line);
            text.setStyle(style);
            HBox.setHgrow((Node)text, (Priority)Priority.NEVER);
            text.getStyleClass().add((Object)"label");
            alignmentBox.getChildren().add((Object)text);
            return alignmentBox;
        }
    }

    private class VerticalLabelNode
    extends LabelNode {
        private VBox fxElement = new VBox();

        public VerticalLabelNode() {
            this.fxElement.setAlignment(Pos.CENTER);
        }

        public VBox getFxElement() {
            return this.fxElement;
        }

        @Override
        public LabelNode provideChildNode() {
            return new HorizontalLabelNode();
        }

        @Override
        protected Orientation getOrientation() {
            return Orientation.VERTICAL;
        }

        @Override
        protected void setMargin(Node text, Insets insets) {
            VBox.setMargin((Node)text, (Insets)insets);
        }

        @Override
        protected void setGrow(Node node) {
            VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
        }
    }
}

