/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnRotateHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class RotateGesture
extends AbstractGesture {
    public static final Class<IOnRotateHandler> ON_ROTATE_POLICY_KEY = IOnRotateHandler.class;
    private Map<Scene, EventHandler<RotateEvent>> rotateFilters = new IdentityHashMap<Scene, EventHandler<RotateEvent>>();

    protected EventHandler<RotateEvent> createRotateFilter(Scene scene) {
        return new EventHandler<RotateEvent>(){

            public void handle(RotateEvent event) {
                if (!(event.getTarget() instanceof Node)) {
                    return;
                }
                IViewer viewer = PartUtils.retrieveViewer(RotateGesture.this.getDomain(), (Node)event.getTarget());
                if (viewer == null) {
                    return;
                }
                if (RotateEvent.ROTATE.equals(event.getEventType())) {
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.rotate(event);
                    }
                } else if (RotateEvent.ROTATION_STARTED.equals(event.getEventType())) {
                    if (!RotateGesture.this.getDomain().isExecutionTransactionOpen(RotateGesture.this)) {
                        RotateGesture.this.getDomain().openExecutionTransaction(RotateGesture.this);
                    }
                    EventTarget eventTarget = event.getTarget();
                    RotateGesture.this.setActiveHandlers(viewer, RotateGesture.this.getHandlerResolver().resolve(RotateGesture.this, eventTarget instanceof Node ? (Node)eventTarget : null, viewer, ON_ROTATE_POLICY_KEY));
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.startRotate(event);
                    }
                } else if (RotateEvent.ROTATION_FINISHED.equals(event.getEventType())) {
                    for (IOnRotateHandler iOnRotateHandler : RotateGesture.this.getActiveHandlers(viewer)) {
                        iOnRotateHandler.endRotate(event);
                    }
                    RotateGesture.this.clearActiveHandlers(viewer);
                    RotateGesture.this.getDomain().closeExecutionTransaction(RotateGesture.this);
                }
            }
        };
    }

    @Override
    protected void doHookScene(Scene scene) {
        EventHandler<RotateEvent> rotateFilter = this.createRotateFilter(scene);
        scene.addEventFilter(RotateEvent.ANY, rotateFilter);
        this.rotateFilters.put(scene, rotateFilter);
    }

    @Override
    protected void doUnhookScene(Scene scene) {
        scene.removeEventFilter(RotateEvent.ANY, this.rotateFilters.remove(scene));
    }

    public List<? extends IOnRotateHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }
}

