/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import org.eclipse.gef.dot.internal.ui.DotNodePart;
import org.eclipse.gef.dot.internal.ui.DotProperties;

public class DotHTMLNodePart
extends DotNodePart {
    private Pane htmlLabelParentVisual;

    @Override
    protected Group doCreateVisual() {
        Group visual = super.doCreateVisual();
        Parent labelParent = this.findFxPaneWithText((Parent)visual, (Node)this.getLabelText());
        if (labelParent instanceof Pane) {
            this.htmlLabelParentVisual = (Pane)labelParent;
            this.htmlLabelParentVisual.getChildren().remove((Object)this.getLabelText());
        } else {
            new IllegalStateException("HTML label could not be visualized");
        }
        return visual;
    }

    private Parent findFxPaneWithText(Parent group, Node text) {
        for (Node node : group.getChildrenUnmodifiable()) {
            Parent possibleParent;
            if (node == text) {
                return group;
            }
            if (!(node instanceof Parent) || (possibleParent = this.findFxPaneWithText((Parent)node, text)) == null) continue;
            return possibleParent;
        }
        return null;
    }

    @Override
    protected void doRefreshVisual(Group visual) {
        super.doRefreshVisual(visual);
        this.refreshHtmlLabelNode();
    }

    protected void refreshHtmlLabelNode() {
        Node fx = DotProperties.getHtmlLikeLabel(this.getContent());
        if (fx != null && !this.htmlLabelParentVisual.getChildren().contains((Object)fx)) {
            this.htmlLabelParentVisual.getChildren().clear();
            this.htmlLabelParentVisual.getChildren().add((Object)fx);
        }
    }
}

