/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import javafx.util.Pair;
import org.eclipse.gef.dot.internal.ui.DotEdgeLabelPart;
import org.eclipse.gef.dot.internal.ui.DotNodePart;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;
import org.eclipse.gef.zest.fx.parts.EdgePart;
import org.eclipse.gef.zest.fx.parts.GraphPart;
import org.eclipse.gef.zest.fx.parts.NodeLabelPart;

public class DotContentPartFactory
implements IContentPartFactory {
    @Inject
    private Injector injector;

    public IContentPart<? extends javafx.scene.Node> createContentPart(Object content, Map<Object, Object> contextMap) {
        Object part = null;
        if (content instanceof Graph) {
            part = new GraphPart();
        } else if (content instanceof Node) {
            part = new DotNodePart();
        } else if (content instanceof Edge) {
            part = new EdgePart();
        } else if (content instanceof Pair && ((Pair)content).getKey() instanceof Edge && ("element-label".equals(((Pair)content).getValue()) || "element-external-label".equals(((Pair)content).getValue()) || "edge-source-label".equals(((Pair)content).getValue()) || "edge-target-label".equals(((Pair)content).getValue()))) {
            part = new DotEdgeLabelPart();
        } else if (content instanceof Pair && ((Pair)content).getKey() instanceof Node && "element-external-label".equals(((Pair)content).getValue())) {
            part = new NodeLabelPart();
        }
        if (part != null) {
            this.injector.injectMembers(part);
        }
        return part;
    }
}

