/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.MapChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.zest.fx.ZestProperties;

public class NodePart
extends AbstractContentPart<Group>
implements ITransformableContentPart<Group>,
IResizableContentPart<Group> {
    protected static final double DEFAULT_SHAPE_PADDING = 5.0;
    private static final String DEFAULT_SHAPE_ROLE = "defaultShape";
    protected static final double ZOOMLEVEL_SHOW_NESTED_GRAPH = 2.0;
    protected static final double DEFAULT_CHILDREN_PANE_WIDTH = 300.0;
    protected static final double DEFAULT_CHILDREN_PANE_HEIGHT = 300.0;
    public static final double DEFAULT_NESTED_CHILDREN_ZOOM_FACTOR = 0.25;
    public static final double DEFAULT_OUTER_LAYOUT_CONTAINER_WIDTH_NESTING = 75.0;
    public static final double DEFAULT_OUTER_LAYOUT_CONTAINER_HEIGHT_NESTING = 75.0;
    public static final String CSS_CLASS = "node";
    public static final String CSS_CLASS_SHAPE = "shape";
    public static final String CSS_CLASS_LABEL = "label";
    public static final String CSS_CLASS_ICON = "icon";
    private static final String NODE_LABEL_EMPTY = "";
    private MapChangeListener<String, Object> nodeAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            NodePart.this.refreshVisual();
        }
    };
    private Text labelText;
    private ImageView iconImageView;
    private Tooltip tooltipNode;
    private VBox vbox;
    private Node shape;
    private Node nestedGraphIcon;
    private StackPane nestedContentStackPane;
    private Pane nestedContentPane;
    private AnchorPane nestedContentAnchorPane;

    private Node createDefaultShape() {
        GeometryNode shape = new GeometryNode((IGeometry)new Rectangle());
        shape.setUserData((Object)DEFAULT_SHAPE_ROLE);
        shape.getStyleClass().add((Object)CSS_CLASS_SHAPE);
        shape.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.REFLECT, Arrays.asList(new Stop(0.0, new Color(1.0, 1.0, 1.0, 1.0)))));
        shape.setStroke((Paint)new Color(0.0, 0.0, 0.0, 1.0));
        shape.setStrokeType(StrokeType.INSIDE);
        return shape;
    }

    private Pane createNestedContentPane() {
        Pane nestedChildrenPaneScaled = new Pane();
        Scale scale = new Scale();
        nestedChildrenPaneScaled.getTransforms().add((Object)scale);
        scale.setX(0.25);
        scale.setY(0.25);
        return nestedChildrenPaneScaled;
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().attributesProperty().addListener(this.nodeAttributesObserver);
    }

    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        this.getNestedContentPane().getChildren().add(index, (Object)child.getVisual());
    }

    protected Group doCreateVisual() {
        Group group = new Group(){

            public boolean isResizable() {
                return true;
            }

            protected void layoutChildren() {
            }

            public double maxHeight(double width) {
                return NodePart.this.vbox.maxHeight(width);
            }

            public double maxWidth(double height) {
                return NodePart.this.vbox.maxWidth(height);
            }

            public double minHeight(double width) {
                return NodePart.this.vbox.minHeight(width);
            }

            public double minWidth(double height) {
                return NodePart.this.vbox.minWidth(height);
            }

            public double prefHeight(double width) {
                return NodePart.this.vbox.prefHeight(width);
            }

            public double prefWidth(double height) {
                return NodePart.this.vbox.prefWidth(height);
            }

            public void resize(double w, double h) {
                NodePart.this.shape.resize(w, h);
                NodePart.this.vbox.setPrefSize(w, h);
                NodePart.this.vbox.autosize();
                Bounds vboxBounds = NodePart.this.vbox.getLayoutBounds();
                NodePart.this.vbox.relocate((w - vboxBounds.getWidth()) / 2.0, (h - vboxBounds.getHeight()) / 2.0);
            }
        };
        this.shape = this.createDefaultShape();
        this.iconImageView = new ImageView();
        this.iconImageView.setImage(null);
        this.iconImageView.getStyleClass().add((Object)CSS_CLASS_ICON);
        this.labelText = new Text();
        this.labelText.setText(NODE_LABEL_EMPTY);
        this.labelText.getStyleClass().add((Object)CSS_CLASS_LABEL);
        HBox hbox = new HBox();
        hbox.getChildren().addAll((Object[])new Node[]{this.iconImageView, this.labelText});
        hbox.setAlignment(Pos.CENTER);
        hbox.setPrefSize(-1.0, -1.0);
        this.nestedContentPane = this.createNestedContentPane();
        this.nestedContentStackPane = new StackPane();
        this.nestedContentStackPane.getChildren().add((Object)this.nestedContentPane);
        this.nestedContentAnchorPane = new AnchorPane();
        this.nestedContentAnchorPane.setStyle("-fx-background-color: white;");
        this.nestedContentAnchorPane.getChildren().add((Object)this.nestedContentStackPane);
        AnchorPane.setLeftAnchor((Node)this.nestedContentStackPane, (Double)-0.5);
        AnchorPane.setTopAnchor((Node)this.nestedContentStackPane, (Double)-0.5);
        AnchorPane.setRightAnchor((Node)this.nestedContentStackPane, (Double)0.5);
        AnchorPane.setBottomAnchor((Node)this.nestedContentStackPane, (Double)0.5);
        VBox.setVgrow((Node)this.nestedContentAnchorPane, (Priority)Priority.ALWAYS);
        this.vbox = new VBox();
        this.vbox.setMouseTransparent(true);
        this.vbox.setAlignment(Pos.CENTER);
        this.vbox.getChildren().addAll((Object[])new Node[]{hbox});
        this.vbox.setPrefSize(-1.0, -1.0);
        group.getChildren().addAll((Object[])new Node[]{this.shape, this.vbox});
        return group;
    }

    protected void doDeactivate() {
        this.getContent().attributesProperty().removeListener(this.nodeAttributesObserver);
        super.doDeactivate();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        Graph nestedGraph = this.getContent().getNestedGraph();
        if (nestedGraph == null) {
            return Collections.emptyList();
        }
        Transform tx = ((Group)this.getVisual()).getLocalToSceneTransform();
        double scale = FX2Geometry.toAffineTransform((Transform)tx).getScaleX();
        if (scale > 2.0) {
            return Collections.singletonList(nestedGraph);
        }
        return Collections.emptyList();
    }

    protected void doRefreshVisual(Group visual) {
        Dimension size;
        org.eclipse.gef.graph.Node node = this.getContent();
        if (node == null) {
            throw new IllegalStateException();
        }
        ReadOnlyMapProperty attrs = node.attributesProperty();
        ArrayList<String> cssClasses = new ArrayList<String>();
        cssClasses.add(CSS_CLASS);
        if (attrs.containsKey("element-css-class")) {
            cssClasses.add(ZestProperties.getCssClass(node));
        }
        if (!visual.getStyleClass().equals(cssClasses)) {
            visual.getStyleClass().setAll(cssClasses);
        }
        String id = null;
        if (attrs.containsKey("element-css-id")) {
            id = ZestProperties.getCssId(node);
        }
        if (visual.getId() != id || id != null && !id.equals(visual.getId())) {
            visual.setId(id);
        }
        this.refreshShape();
        if (attrs.containsKey("node-rect-css-style") && this.getShape() != null && !this.getShape().getStyle().equals(ZestProperties.getShapeCssStyle(node))) {
            this.getShape().setStyle(ZestProperties.getShapeCssStyle(node));
        }
        if (attrs.containsKey("element-label-css-style") && this.getLabelText() != null && !this.getLabelText().getStyle().equals(ZestProperties.getLabelCssStyle(node))) {
            this.getLabelText().setStyle(ZestProperties.getLabelCssStyle(node));
        }
        if (this.vbox != null) {
            if (this.getShape() != null && DEFAULT_SHAPE_ROLE.equals(this.getShape().getUserData()) || this.isNesting()) {
                this.vbox.setPadding(new Insets(5.0));
            } else {
                this.vbox.setPadding(Insets.EMPTY);
            }
            if (this.isNesting()) {
                if (!this.vbox.getChildren().contains((Object)this.nestedContentAnchorPane)) {
                    this.vbox.getChildren().add((Object)this.nestedContentAnchorPane);
                    if (this.vbox.getPrefWidth() == -1.0 && this.vbox.getPrefHeight() == -1.0) {
                        this.vbox.setPrefSize(75.0, 75.0);
                        this.vbox.autosize();
                    }
                }
                if (!this.getChildrenUnmodifiable().isEmpty()) {
                    this.hideNestedGraphIcon();
                } else {
                    this.showNestedGraphIcon();
                }
            } else if (this.vbox.getChildren().contains((Object)this.nestedContentAnchorPane)) {
                this.vbox.getChildren().remove((Object)this.nestedContentAnchorPane);
                this.vbox.setPrefSize(-1.0, -1.0);
                this.vbox.autosize();
            }
        }
        this.refreshLabel();
        this.refreshIcon();
        this.refreshTooltip();
        Point position = ZestProperties.getPosition(node);
        if (position != null) {
            Affine newTransform = new Affine((Transform)new Translate(position.x, position.y));
            if (!NodeUtils.equals((Affine)this.getVisualTransform(), (Affine)newTransform)) {
                this.setVisualTransform(newTransform);
            }
        }
        if ((size = ZestProperties.getSize(node)) != null) {
            ((Group)this.getVisual()).resize(size.width, size.height);
        } else {
            ((Group)this.getVisual()).autosize();
        }
    }

    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        this.getNestedContentPane().getChildren().remove(index);
    }

    public org.eclipse.gef.graph.Node getContent() {
        return (org.eclipse.gef.graph.Node)super.getContent();
    }

    public Dimension getContentSize() {
        Dimension size = ZestProperties.getSize(this.getContent());
        if (size == null) {
            size = new Dimension();
        }
        return size;
    }

    public Affine getContentTransform() {
        Point position = ZestProperties.getPosition(this.getContent());
        if (position == null) {
            position = new Point();
        }
        return new Affine((Transform)new Translate(position.x, position.y));
    }

    protected ImageView getIconImageView() {
        return this.iconImageView;
    }

    protected Text getLabelText() {
        return this.labelText;
    }

    private Pane getNestedContentPane() {
        return this.nestedContentPane;
    }

    private StackPane getNestedContentStackPane() {
        return this.nestedContentStackPane;
    }

    public Node getShape() {
        return this.shape;
    }

    private void hideNestedGraphIcon() {
        if (this.nestedGraphIcon != null) {
            this.getNestedContentStackPane().getChildren().remove((Object)this.nestedGraphIcon);
            this.nestedGraphIcon = null;
        }
    }

    private boolean isNesting() {
        return this.getContent().getNestedGraph() != null;
    }

    protected void refreshIcon() {
        Image icon = ZestProperties.getIcon(this.getContent());
        if (this.getIconImageView() != null && this.getIconImageView().getImage() != icon) {
            this.getIconImageView().setImage(icon);
        }
    }

    protected void refreshLabel() {
        String label = ZestProperties.getLabel(this.getContent());
        if (label == null || label.isEmpty()) {
            label = NODE_LABEL_EMPTY;
        }
        if (this.getLabelText() != null && !this.getLabelText().getText().equals(label)) {
            this.getLabelText().setText(label);
        }
    }

    private void refreshShape() {
        Node shape = ZestProperties.getShape(this.getContent());
        if (this.shape != shape && shape != null) {
            ((Group)this.getVisual()).getChildren().remove((Object)shape);
            this.shape = shape;
            if (shape instanceof GeometryNode) {
                ((GeometryNode)shape).setStrokeType(StrokeType.INSIDE);
            } else if (shape instanceof Shape) {
                ((Shape)shape).setStrokeType(StrokeType.INSIDE);
            }
            if (!shape.getStyleClass().contains((Object)CSS_CLASS_SHAPE)) {
                shape.getStyleClass().add((Object)CSS_CLASS_SHAPE);
            }
            ((Group)this.getVisual()).getChildren().add(0, (Object)shape);
        }
    }

    protected void refreshTooltip() {
        String tooltip = ZestProperties.getTooltip(this.getContent());
        if (tooltip != null && !tooltip.isEmpty()) {
            if (this.tooltipNode == null) {
                this.tooltipNode = new Tooltip(tooltip);
                Tooltip.install((Node)this.getVisual(), (Tooltip)this.tooltipNode);
            } else {
                this.tooltipNode.setText(tooltip);
            }
        } else if (this.tooltipNode != null) {
            Tooltip.uninstall((Node)this.getVisual(), (Tooltip)this.tooltipNode);
        }
    }

    public void setContentSize(Dimension size) {
        ZestProperties.setSize(this.getContent(), size);
    }

    public void setContentTransform(Affine totalTransform) {
        ZestProperties.setPosition(this.getContent(), new Point(totalTransform.getTx(), totalTransform.getTy()));
    }

    private void showNestedGraphIcon() {
        if (this.nestedGraphIcon == null) {
            this.nestedGraphIcon = new NestedGraphIcon();
            this.getNestedContentStackPane().getChildren().add((Object)this.nestedGraphIcon);
        }
    }

    public static class NestedGraphIcon
    extends Group {
        public NestedGraphIcon() {
            Circle n0 = this.node(-20.0, -20.0);
            Circle n1 = this.node(-10.0, 10.0);
            Circle n2 = this.node(5.0, -15.0);
            Circle n3 = this.node(15.0, -25.0);
            Circle n4 = this.node(20.0, 5.0);
            this.getChildren().addAll((Object[])new Node[]{this.edge(n0, n1), this.edge(n1, n2), this.edge(n2, n3), this.edge(n3, n4), this.edge(n1, n4), n0, n1, n2, n3, n4});
        }

        private Node edge(Circle n, Circle m) {
            Line line = new Line(n.getCenterX(), n.getCenterY(), m.getCenterX(), m.getCenterY());
            line.setStroke((Paint)Color.BLACK);
            return line;
        }

        private Circle node(double x, double y) {
            return new Circle(x, y, 5.0, (Paint)Color.BLACK);
        }
    }
}

