/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.collect.Multiset;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.parts.AbstractVisualPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class LayeredRootPart
extends AbstractVisualPart<Group>
implements IRootPart<Group> {
    private Group contentLayer;
    private Group handleLayer;
    private Group feedbackLayer;

    @Override
    protected void activateChildren() {
        for (IVisualPart<Object> child : this.getContentPartChildren()) {
            child.activate();
        }
        for (IVisualPart<Object> child : this.getChildrenUnmodifiable()) {
            if (child instanceof IContentPart) continue;
            child.activate();
        }
    }

    protected Group createContentLayer() {
        Group contentLayer = this.createLayer(false);
        contentLayer.setPickOnBounds(true);
        return contentLayer;
    }

    protected Group createFeedbackLayer() {
        return this.createLayer(true);
    }

    protected Group createHandleLayer() {
        return this.createLayer(false);
    }

    protected Group createLayer(boolean mouseTransparent) {
        Group layer = new Group();
        layer.setPickOnBounds(false);
        layer.setMouseTransparent(mouseTransparent);
        return layer;
    }

    @Override
    protected void deactivateChildren() {
        for (IVisualPart<Object> child : this.getContentPartChildren()) {
            child.deactivate();
        }
        for (IVisualPart<Object> child : this.getChildrenUnmodifiable()) {
            if (child instanceof IContentPart) continue;
            child.deactivate();
        }
    }

    @Override
    protected IViewer determineViewer(IVisualPart<? extends Node> parent, Multiset<IVisualPart<? extends Node>> anchoreds) {
        return this.getViewer();
    }

    @Override
    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        if (child instanceof IContentPart) {
            int contentLayerIndex = 0;
            int i = 0;
            while (i < index) {
                if (i < this.getChildrenUnmodifiable().size() && this.getChildrenUnmodifiable().get(i) instanceof IContentPart) {
                    ++contentLayerIndex;
                }
                ++i;
            }
            this.getContentLayer().getChildren().add(contentLayerIndex, (Object)child.getVisual());
        } else if (child instanceof IFeedbackPart) {
            int feedbackLayerIndex = 0;
            int i = 0;
            while (i < index) {
                if (i < this.getChildrenUnmodifiable().size() && this.getChildrenUnmodifiable().get(i) instanceof IFeedbackPart) {
                    ++feedbackLayerIndex;
                }
                ++i;
            }
            this.getFeedbackLayer().getChildren().add(feedbackLayerIndex, (Object)child.getVisual());
        } else {
            int handleLayerIndex = 0;
            int i = 0;
            while (i < index) {
                if (i < this.getChildrenUnmodifiable().size() && this.getChildrenUnmodifiable().get(i) instanceof IHandlePart) {
                    ++handleLayerIndex;
                }
                ++i;
            }
            this.getHandleLayer().getChildren().add(handleLayerIndex, (Object)child.getVisual());
        }
    }

    @Override
    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        throw new UnsupportedOperationException("IRootVisualPart does not support this");
    }

    @Override
    protected Group doCreateVisual() {
        this.contentLayer = this.createContentLayer();
        this.contentLayer.boundsInLocalProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            }
        });
        this.feedbackLayer = this.createFeedbackLayer();
        this.handleLayer = this.createHandleLayer();
        return new Group(new Node[]{this.contentLayer, this.feedbackLayer, this.handleLayer});
    }

    @Override
    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        throw new UnsupportedOperationException("IRootVisualPart does not support this");
    }

    @Override
    protected void doRefreshVisual(Group visual) {
    }

    @Override
    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        if (child instanceof IContentPart) {
            this.getContentLayer().getChildren().remove((Object)child.getVisual());
        } else if (child instanceof IFeedbackPart) {
            this.getFeedbackLayer().getChildren().remove((Object)child.getVisual());
        } else {
            this.getHandleLayer().getChildren().remove((Object)child.getVisual());
        }
    }

    public Group getContentLayer() {
        if (this.contentLayer == null) {
            this.doCreateVisual();
        }
        return this.contentLayer;
    }

    @Override
    public List<IContentPart<? extends Node>> getContentPartChildren() {
        return PartUtils.filterParts(this.getChildrenUnmodifiable(), IContentPart.class);
    }

    public Group getFeedbackLayer() {
        if (this.feedbackLayer == null) {
            this.doCreateVisual();
        }
        return this.feedbackLayer;
    }

    @Override
    public List<IFeedbackPart<? extends Node>> getFeedbackPartChildren() {
        return PartUtils.filterParts(this.getChildrenUnmodifiable(), IFeedbackPart.class);
    }

    public Group getHandleLayer() {
        if (this.handleLayer == null) {
            this.doCreateVisual();
        }
        return this.handleLayer;
    }

    @Override
    public List<IHandlePart<? extends Node>> getHandlePartChildren() {
        return PartUtils.filterParts(this.getChildrenUnmodifiable(), IHandlePart.class);
    }

    @Override
    public IRootPart<? extends Node> getRoot() {
        return this;
    }
}

