/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.geometry.Pos;
import javafx.scene.Parent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.handlers.PanningSupport;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;
import org.eclipse.gef.mvc.fx.ui.MvcFxUiBundle;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractViewerAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;

public class FitToViewportAction
extends AbstractViewerAction {
    private PanningSupport panningSupport = new PanningSupport();

    public FitToViewportAction() {
        this("Fit-To-Viewport", 1, MvcFxUiBundle.getDefault().getImageRegistry().getDescriptor("IMG_ICONS_FIT_TO_VIEWPORT"));
    }

    protected FitToViewportAction(String text, int style, ImageDescriptor imageDescriptor) {
        super(text, style, imageDescriptor);
    }

    @Override
    protected ITransactionalOperation createOperation(Event event) {
        InfiniteCanvas infiniteCanvas = this.getInfiniteCanvas();
        if (infiniteCanvas == null) {
            throw new IllegalStateException("Cannot perform FitToSizeAction, because no InfiniteCanvas can be determiend.");
        }
        if (infiniteCanvas.getContentBounds().isEmpty()) {
            return null;
        }
        ViewportPolicy viewportPolicy = (ViewportPolicy)this.getViewer().getRootPart().getAdapter(ViewportPolicy.class);
        if (viewportPolicy == null) {
            throw new IllegalStateException("Cannot perform FitToViewportAction, because no ViewportPolicy can be determined for the root part.");
        }
        viewportPolicy.init();
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(viewportPolicy, Pos.TOP_LEFT, true);
        }
        viewportPolicy.fitToSize(this.getMinZoom(), this.getMaxZoom());
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(viewportPolicy, Pos.BOTTOM_RIGHT, false);
        }
        return viewportPolicy.commit();
    }

    protected InfiniteCanvas getInfiniteCanvas() {
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            return (InfiniteCanvas)canvas;
        }
        return null;
    }

    protected double getMaxZoom() {
        return 4.0;
    }

    protected double getMinZoom() {
        return 0.25;
    }

    protected boolean isContentRestricted() {
        return false;
    }
}

