/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.color.ColorPackage;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotColorJavaValidator;
import org.eclipse.xtext.validation.Check;

public class DotColorJavaValidator
extends AbstractDotColorJavaValidator {
    @Check
    public void checkConsistentColorSchemeAndColorName(StringColor color) {
        String colorScheme = color.getScheme();
        if (colorScheme != null && !colorScheme.isEmpty() && !DotColors.getColorSchemes().contains(colorScheme)) {
            this.error("'" + colorScheme + "' is not a valid color scheme.", (EStructuralFeature)ColorPackage.Literals.STRING_COLOR__SCHEME);
        } else {
            colorScheme = colorScheme != null ? colorScheme : "x11";
            String colorName = color.getName();
            if (colorName != null && !colorName.isEmpty() && !DotColors.getColorNames(colorScheme).contains(colorName)) {
                this.error("The '" + colorName + "' color is not valid within the '" + colorScheme + "' color scheme.", (EStructuralFeature)ColorPackage.Literals.STRING_COLOR__SCHEME);
            }
        }
    }
}

