/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.gef.examples.text.model.Block;
import org.eclipse.gef.examples.text.model.ModelUtil;
import org.eclipse.gef.examples.text.model.TextRun;

public class TestModelUtil
extends TestCase {
    static List result;

    public void testNestedBegin() {
        Block doc = new Block(5);
        Block branch1 = new Block(0);
        TextRun start = new TextRun("12345");
        doc.add(branch1);
        branch1.add(start);
        TextRun end = new TextRun("ABCDE");
        doc.add(end);
        int i = 0;
        while (i < 3) {
            result = ModelUtil.getModelSpan(start, 0, end, 5);
            this.compareList(result, new Object[]{branch1, end});
            result = ModelUtil.getModelSpan(start, 1, end, 5);
            this.compareList(result, new Object[]{end});
            result = ModelUtil.getModelSpan(start, 0, end, 3);
            this.compareList(result, new Object[]{branch1});
            result = ModelUtil.getModelSpan(start, 1, end, 3);
            TestModelUtil.assertTrue((boolean)result.isEmpty());
            doc.add(new TextRun("bogus"), 0);
            ++i;
        }
        TextRun middle = new TextRun("I'm in the middle");
        doc.add(middle, doc.getChildren().indexOf(end));
        result = ModelUtil.getModelSpan(start, 0, end, 5);
        this.compareList(result, new Object[]{branch1, middle, end});
        result = ModelUtil.getModelSpan(start, 1, end, 4);
        this.compareList(result, new Object[]{middle});
    }

    public void testNestedEnd() {
        Block doc = new Block(5);
        Block branch1 = new Block(0);
        TextRun run123 = new TextRun("12345");
        branch1.add(run123);
        TextRun runABC = new TextRun("ABCDE");
        doc.add(runABC);
        doc.add(branch1);
        int i = 0;
        while (i < 3) {
            result = ModelUtil.getModelSpan(runABC, 0, run123, 5);
            this.compareList(result, new Object[]{runABC, branch1});
            result = ModelUtil.getModelSpan(runABC, 1, run123, 5);
            this.compareList(result, new Object[]{branch1});
            result = ModelUtil.getModelSpan(runABC, 0, run123, 4);
            this.compareList(result, new Object[]{runABC});
            TestModelUtil.assertTrue((boolean)ModelUtil.getModelSpan(runABC, 1, run123, 4).isEmpty());
            doc.add(new TextRun("bogus"), 0);
            doc.add(new TextRun("bogus"), doc.getChildren().size());
            ++i;
        }
        TextRun middle = new TextRun("I'm in the middle");
        doc.add(middle, doc.getChildren().indexOf(branch1));
        result = ModelUtil.getModelSpan(runABC, 0, run123, 5);
        this.compareList(result, new Object[]{runABC, middle, branch1});
        result = ModelUtil.getModelSpan(runABC, 1, run123, 4);
        this.compareList(result, new Object[]{middle});
    }

    private void compareList(List result, Object[] array) {
        Object[] compare = result.toArray();
        TestModelUtil.assertEquals((int)array.length, (int)compare.length);
        int i = 0;
        while (i < compare.length) {
            TestModelUtil.assertEquals((Object)compare[i], (Object)array[i]);
            ++i;
        }
    }
}

