/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.gef.examples.shapes.model.ShapesDiagram;

public class ShapeDeleteCommand
extends Command {
    private final Shape child;
    private final ShapesDiagram parent;
    private List sourceConnections;
    private List targetConnections;
    private boolean wasRemoved;

    public ShapeDeleteCommand(ShapesDiagram parent, Shape child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("shape deletion");
        this.parent = parent;
        this.child = child;
    }

    private void addConnections(List connections) {
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            conn.reconnect();
        }
    }

    public boolean canUndo() {
        return this.wasRemoved;
    }

    public void execute() {
        this.sourceConnections = this.child.getSourceConnections();
        this.targetConnections = this.child.getTargetConnections();
        this.redo();
    }

    public void redo() {
        this.wasRemoved = this.parent.removeChild(this.child);
        if (this.wasRemoved) {
            this.removeConnections(this.sourceConnections);
            this.removeConnections(this.targetConnections);
        }
    }

    private void removeConnections(List connections) {
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            conn.disconnect();
        }
    }

    public void undo() {
        if (this.parent.addChild(this.child)) {
            this.addConnections(this.sourceConnections);
            this.addConnections(this.targetConnections);
        }
    }
}

