/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;

public abstract class SnapToHelper
implements PositionConstants {
    protected void makeAbsolute(IFigure figure, Translatable t) {
        figure.translateToAbsolute(t);
    }

    protected void makeRelative(IFigure figure, Translatable t) {
        figure.translateToRelative(t);
    }

    public int snapPoint(Request request, int snapDirections, PrecisionPoint where, PrecisionPoint result) {
        PrecisionRectangle rect = new PrecisionRectangle();
        PrecisionRectangle resultRect = new PrecisionRectangle();
        rect.preciseX = where.preciseX;
        rect.preciseY = where.preciseY;
        rect.updateInts();
        snapDirections = this.snapRectangle(request, snapDirections, rect, resultRect);
        result.preciseX += resultRect.preciseX;
        result.preciseY += resultRect.preciseY;
        result.updateInts();
        return snapDirections;
    }

    public int snapPoint(Request request, int snapLocations, PrecisionRectangle[] rects, PrecisionPoint result) {
        PrecisionRectangle resultRect = new PrecisionRectangle();
        snapLocations = this.snapRectangle(request, snapLocations, rects, resultRect);
        result.preciseX += resultRect.preciseX;
        result.preciseY += resultRect.preciseY;
        result.updateInts();
        return snapLocations;
    }

    public int snapRectangle(Request request, int snapOrientation, PrecisionRectangle[] baseRects, PrecisionRectangle result) {
        int i = 0;
        while (i < baseRects.length && snapOrientation != 0) {
            snapOrientation = this.snapRectangle(request, snapOrientation, baseRects[i], result);
            ++i;
        }
        return snapOrientation;
    }

    public abstract int snapRectangle(Request var1, int var2, PrecisionRectangle var3, PrecisionRectangle var4);
}

