/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.mvc.fx.policies.IFXOnHoverPolicy;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXHoverTool
extends AbstractTool<Node> {
    public static final Class<IFXOnHoverPolicy> ON_HOVER_POLICY_KEY = IFXOnHoverPolicy.class;
    @Inject
    private ITargetPolicyResolver targetPolicyResolver;
    private final Map<Scene, EventHandler<MouseEvent>> hoverFilters = new HashMap<Scene, EventHandler<MouseEvent>>();

    protected EventHandler<MouseEvent> createHoverFilter(FXViewer viewer) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!(event.getEventType().equals(MouseEvent.MOUSE_MOVED) || event.getEventType().equals(MouseEvent.MOUSE_ENTERED_TARGET) || event.getEventType().equals(MouseEvent.MOUSE_EXITED_TARGET))) {
                    return;
                }
                EventTarget eventTarget = event.getTarget();
                if (eventTarget instanceof Node) {
                    List<IFXOnHoverPolicy> policies = FXHoverTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXHoverTool.this, (Node)eventTarget, ON_HOVER_POLICY_KEY);
                    FXHoverTool.this.getDomain().openExecutionTransaction((ITool)FXHoverTool.this);
                    for (IFXOnHoverPolicy policy : policies) {
                        policy.hover(event);
                    }
                    FXHoverTool.this.getDomain().closeExecutionTransaction((ITool)FXHoverTool.this);
                }
            }
        };
    }

    protected void registerListeners() {
        super.registerListeners();
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene;
            if (!(viewer instanceof FXViewer) || this.hoverFilters.containsKey(scene = ((Node)viewer.getRootPart().getVisual()).getScene())) continue;
            EventHandler<MouseEvent> hoverFilter = this.createHoverFilter((FXViewer)viewer);
            scene.addEventFilter(MouseEvent.ANY, hoverFilter);
            this.hoverFilters.put(scene, hoverFilter);
        }
    }

    protected void unregisterListeners() {
        for (Scene scene : this.hoverFilters.keySet()) {
            scene.removeEventFilter(MouseEvent.ANY, this.hoverFilters.remove(scene));
        }
        super.unregisterListeners();
    }
}

