/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.geometry.Bounds;
import javafx.scene.input.ScrollEvent;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXChangeViewportPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnScrollPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;

public class FXPanOrZoomOnScrollPolicy
extends AbstractFXInteractionPolicy
implements IFXOnScrollPolicy {
    private boolean stopped = false;
    private FXChangeViewportPolicy viewportPolicy;

    protected Dimension computeDelta(ScrollEvent event) {
        double dx = event.getDeltaX();
        double dy = event.getDeltaY();
        if (this.isSwapDirection(event)) {
            double t = dx;
            dx = dy;
            dy = t;
        }
        return new Dimension(dx, dy);
    }

    protected FXChangeViewportPolicy determineViewportPolicy() {
        return (FXChangeViewportPolicy)((Object)this.getHost().getRoot().getAdapter(FXChangeViewportPolicy.class));
    }

    protected FXChangeViewportPolicy getViewportPolicy() {
        return this.viewportPolicy;
    }

    protected boolean isPan(ScrollEvent event) {
        return !event.isAltDown() && !event.isControlDown() && !event.isMetaDown();
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    protected boolean isSwapDirection(ScrollEvent event) {
        return event.isShiftDown();
    }

    protected boolean isZoom(ScrollEvent event) {
        return event.isControlDown() || event.isAltDown();
    }

    @Override
    public void scroll(ScrollEvent event) {
        if (this.isPan(event) && !this.isStopped()) {
            Dimension delta = this.computeDelta(event);
            this.setStopped(this.stopAtContentBounds(delta));
            this.getViewportPolicy().scrollRelative(delta.width, delta.height);
        } else if (this.isZoom(event)) {
            this.getViewportPolicy().zoomRelative(event.getDeltaY() > 0.0 ? 1.05 : 0.9523809523809523, event.getSceneX(), event.getSceneY());
        }
    }

    @Override
    public void scrollAborted() {
        this.rollback(this.getViewportPolicy());
        this.setViewportPolicy(null);
        this.setStopped(false);
    }

    @Override
    public void scrollFinished() {
        this.commit(this.getViewportPolicy());
        this.setViewportPolicy(null);
        this.setStopped(false);
    }

    @Override
    public void scrollStarted(ScrollEvent event) {
        this.setViewportPolicy(this.determineViewportPolicy());
        this.init(this.getViewportPolicy());
        this.scroll(event);
    }

    protected void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    protected void setViewportPolicy(FXChangeViewportPolicy viewportPolicy) {
        this.viewportPolicy = viewportPolicy;
    }

    protected boolean stopAtContentBounds(Dimension delta) {
        InfiniteCanvas infiniteCanvas = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas();
        Bounds contentBounds = infiniteCanvas.getContentBounds();
        boolean stopped = false;
        if (contentBounds.getMinX() < 0.0 && contentBounds.getMinX() + delta.width >= 0.0) {
            delta.width = -contentBounds.getMinX();
            stopped = true;
        } else if (contentBounds.getMaxX() > infiniteCanvas.getWidth() && contentBounds.getMaxX() + delta.width <= infiniteCanvas.getWidth()) {
            delta.width = infiniteCanvas.getWidth() - contentBounds.getMaxX();
            stopped = true;
        }
        if (contentBounds.getMinY() < 0.0 && contentBounds.getMinY() + delta.height >= 0.0) {
            delta.height = -contentBounds.getMinY();
            stopped = true;
        } else if (contentBounds.getMaxY() > infiniteCanvas.getHeight() && contentBounds.getMaxY() + delta.height <= infiniteCanvas.getHeight()) {
            delta.height = infiniteCanvas.getHeight() - contentBounds.getMaxY();
            stopped = true;
        }
        return stopped;
    }
}

