/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultHoverFeedbackPartFactory;

public class FXHoverFeedbackPart
extends AbstractFXFeedbackPart<GeometryNode<IGeometry>> {
    private Provider<? extends IGeometry> feedbackGeometryProvider;

    protected GeometryNode<IGeometry> createVisual() {
        GeometryNode visual = new GeometryNode();
        visual.setFill((Paint)Color.TRANSPARENT);
        visual.setMouseTransparent(true);
        visual.setManaged(false);
        visual.setStrokeType(StrokeType.OUTSIDE);
        visual.setStrokeWidth(1.0);
        visual.setEffect(this.getHoverFeedbackEffect());
        visual.setStroke((Paint)this.getHoverStroke());
        return visual;
    }

    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        if (this.getAnchoragesUnmodifiable().size() != 1) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((GeometryNode)this.getVisual()).getParent(), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    public Effect getHoverFeedbackEffect() {
        DropShadow effect = new DropShadow();
        effect.setRadius(3.0);
        return effect;
    }

    protected Color getHoverStroke() {
        Provider hoverFeedbackColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"HOVER_FEEDBACK_COLOR_PROVIDER"));
        return hoverFeedbackColorProvider == null ? FXDefaultHoverFeedbackPartFactory.DEFAULT_HOVER_FEEDBACK_COLOR : (Color)hoverFeedbackColorProvider.get();
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

