/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.ui.view;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Scene;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.MvcLogoExample;
import org.eclipse.gef4.mvc.examples.logo.MvcLogoExampleModule;
import org.eclipse.gef4.mvc.examples.logo.MvcLogoExampleViewersComposite;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.ui.MvcLogoExampleUiModule;
import org.eclipse.gef4.mvc.examples.logo.ui.properties.FXCurvePropertySource;
import org.eclipse.gef4.mvc.fx.ui.parts.AbstractFXView;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.ui.properties.SetPropertyValueOperation;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetPage;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class MvcLogoExampleView
extends AbstractFXView {
    private UndoablePropertySheetEntry rootEntry;

    public MvcLogoExampleView() {
        super(Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new MvcLogoExampleModule()}).with(new Module[]{new MvcLogoExampleUiModule()})}));
        ((ContentModel)this.getContentViewer().getAdapter(ContentModel.class)).getContents().setAll((Collection)MvcLogoExample.createDefaultContents());
        ((ContentModel)this.getPaletteViewer().getAdapter(ContentModel.class)).getContents().setAll((Collection)MvcLogoExample.createPaletteContents());
    }

    public void dispose() {
        ((ContentModel)this.getContentViewer().getAdapter(ContentModel.class)).contentsProperty().clear();
        ((ContentModel)this.getPaletteViewer().getAdapter(ContentModel.class)).contentsProperty().clear();
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (IPropertySheetPage.class.equals((Object)key)) {
            UndoablePropertySheetPage propertySheetPage = (UndoablePropertySheetPage)super.getAdapter(key);
            if (this.rootEntry == null) {
                this.rootEntry = new UndoablePropertySheetEntry((IOperationHistory)this.getAdapter(IOperationHistory.class), (IUndoContext)this.getAdapter(IUndoContext.class)){

                    private Point computeEndHint(Connection connection) {
                        if (connection.getEndAnchor() instanceof DynamicAnchor && connection.getPointsUnmodifiable().size() > 1) {
                            Point endPoint = connection.getEndPoint();
                            Point neighbor = connection.getPoint(connection.getPointsUnmodifiable().size() - 2);
                            Point translated = endPoint.getTranslated(endPoint.getDifference(neighbor).getScaled(0.5));
                            return translated;
                        }
                        return null;
                    }

                    private Point computeStartHint(Connection connection) {
                        if (connection.getStartAnchor() instanceof DynamicAnchor && connection.getPointsUnmodifiable().size() > 1) {
                            Point startPoint = connection.getStartPoint();
                            Point neighbor = connection.getPoint(1);
                            Point translated = startPoint.getTranslated(startPoint.getDifference(neighbor).getScaled(0.5));
                            return translated;
                        }
                        return null;
                    }

                    public void setValues(Object[] objects) {
                        if (objects == null || objects.length == 0) {
                            objects = new Object[]{((ContentModel)MvcLogoExampleView.this.getContentViewer().getAdapter(ContentModel.class)).getContents().get(0)};
                        }
                        super.setValues(objects);
                    }

                    protected void valueChanged(UndoablePropertySheetEntry child, ITransactionalOperation operation) {
                        if (operation instanceof SetPropertyValueOperation) {
                            SetPropertyValueOperation changeRoutingStyleOperation = (SetPropertyValueOperation)operation;
                            if (changeRoutingStyleOperation.getPropertySource() instanceof FXCurvePropertySource && FXCurvePropertySource.ROUTING_STYLE_PROPERTY.getId().equals(changeRoutingStyleOperation.getPropertyId())) {
                                FXCurvePropertySource ps = (FXCurvePropertySource)changeRoutingStyleOperation.getPropertySource();
                                IContentPart contentPart = (IContentPart)MvcLogoExampleView.this.getContentViewer().getContentPartMap().get(ps.getCurve());
                                ArrayList<Point> newWaypoints = new ArrayList<Point>();
                                List currentWaypoints = ps.getCurve().getWayPointsCopy();
                                newWaypoints.add(this.computeStartHint((Connection)contentPart.getVisual()));
                                newWaypoints.add(this.computeEndHint((Connection)contentPart.getVisual()));
                                ChangeWayPointsOperation clearWaypointsOperation = new ChangeWayPointsOperation("Clear waypoints", ps.getCurve(), currentWaypoints, newWaypoints);
                                ForwardUndoCompositeOperation c = new ForwardUndoCompositeOperation("Change routing style");
                                c.add((IUndoableOperation)changeRoutingStyleOperation);
                                c.add((IUndoableOperation)clearWaypointsOperation);
                                DeselectOperation deselectOperation = new DeselectOperation((IViewer)MvcLogoExampleView.this.getContentViewer(), Collections.singletonList(contentPart));
                                SelectOperation selectOperation = new SelectOperation((IViewer)MvcLogoExampleView.this.getContentViewer(), Collections.singletonList(contentPart));
                                c.add((IUndoableOperation)deselectOperation);
                                c.add((IUndoableOperation)selectOperation);
                                super.valueChanged(child, (ITransactionalOperation)c);
                            } else {
                                super.valueChanged(child, operation);
                            }
                        } else {
                            super.valueChanged(child, operation);
                        }
                    }
                };
                propertySheetPage.setRootEntry((IPropertySheetEntry)this.rootEntry);
            }
            return propertySheetPage;
        }
        return super.getAdapter(key);
    }

    protected FXViewer getPaletteViewer() {
        return (FXViewer)this.getDomain().getAdapter(AdapterKey.get(FXViewer.class, (String)"paletteViewer"));
    }

    protected void hookViewers() {
        MvcLogoExampleViewersComposite viewersComposite = new MvcLogoExampleViewersComposite(this.getContentViewer(), this.getPaletteViewer());
        this.getCanvas().setScene(new Scene(viewersComposite.getComposite()));
    }

    public static final class ChangeWayPointsOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private final FXGeometricCurve curve;
        private final List<Point> newWayPoints;
        private final List<Point> oldWayPoints;

        public ChangeWayPointsOperation(String label, FXGeometricCurve curve, List<Point> oldWayPoints, List<Point> newWayPoints) {
            super(label);
            this.curve = curve;
            this.oldWayPoints = oldWayPoints;
            this.newWayPoints = newWayPoints;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.newWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }

        public boolean isContentRelevant() {
            return true;
        }

        public boolean isNoOp() {
            return this.oldWayPoints == this.newWayPoints || this.oldWayPoints != null && this.oldWayPoints.equals(this.newWayPoints);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.oldWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }
    }
}

