/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Straight;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.internal.utils.PointListUtils;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.projective.Vector3D;

public class Line
extends BezierCurve {
    private static final long serialVersionUID = 1L;

    public Line(double ... coordinates) {
        super(coordinates);
        if (coordinates.length != 4) {
            throw new IllegalArgumentException("A Line may only be defined by 4 coordinates (2 points), while " + coordinates.length + " were passed in.");
        }
    }

    public Line(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
    }

    public Line(Point ... points) {
        super(points);
        if (points.length != 2) {
            throw new IllegalArgumentException("A Line may only be defined by two points, while " + points.length + " were passed in.");
        }
    }

    public Line(Point p1, Point p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    @Override
    public boolean contains(Point p) {
        if (p == null) {
            return false;
        }
        if (this.getP1().equals(p) || this.getP2().equals(p)) {
            return true;
        }
        double distance = Math.abs(new Straight(this.getP1(), this.getP2()).getSignedDistanceCCW(new Vector(p)));
        return PrecisionUtils.equal(distance, 0.0) && this.getBounds().contains(p);
    }

    public boolean equals(double x1, double y1, double x2, double y2) {
        return PrecisionUtils.equal(x1, this.getX1()) && PrecisionUtils.equal(y1, this.getY1()) && PrecisionUtils.equal(x2, this.getX2()) && PrecisionUtils.equal(y2, this.getY2()) || PrecisionUtils.equal(x2, this.getX1()) && PrecisionUtils.equal(y2, this.getY1()) && PrecisionUtils.equal(x1, this.getX2()) && PrecisionUtils.equal(y1, this.getY2());
    }

    @Override
    public Point get(double t) {
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("t out of range: " + t);
        }
        return new Point((1.0 - t) * this.getX1() + t * this.getX2(), (1.0 - t) * this.getY1() + t * this.getY2());
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getP1(), this.getP2());
    }

    @Override
    public Line getCopy() {
        return new Line(this.getP1(), this.getP2());
    }

    public Angle getDirectionCCW() {
        Point start = this.getP1();
        Point end = this.getP2();
        return Angle.fromRad(Math.atan2(end.y - start.y, end.x - start.x));
    }

    public Angle getDirectionCW() {
        return this.getDirectionCCW().getOppositeFull();
    }

    public Point getIntersection(Line l) {
        Point lp2;
        Point p2;
        Point p1 = this.getP1();
        if (p1.equals(p2 = this.getP2())) {
            if (l.contains(p1)) {
                return p1;
            }
            if (l.contains(p2)) {
                return p2;
            }
            return null;
        }
        Point lp1 = l.getP1();
        if (lp1.equals(lp2 = l.getP2())) {
            if (this.contains(lp1)) {
                return lp1;
            }
            if (this.contains(lp2)) {
                return lp2;
            }
            return null;
        }
        Straight s1 = new Straight(p1, p2);
        Straight s2 = new Straight(lp1, lp2);
        if (s1.isParallelTo(s2)) {
            Vector vlp1 = new Vector(lp1);
            Vector vlp2 = new Vector(lp2);
            if (s1.contains(vlp1) && s1.contains(vlp2)) {
                double u1 = s1.getParameterAt(vlp1);
                double u2 = s1.getParameterAt(vlp2);
                if (PrecisionUtils.equal(u1, 0.0) && u2 < u1 || PrecisionUtils.equal(u1, 1.0) && u2 > u1) {
                    return lp1;
                }
                if (PrecisionUtils.equal(u2, 0.0) && u1 < u2 || PrecisionUtils.equal(u2, 1.0) && u1 > u2) {
                    return lp2;
                }
            }
            return null;
        }
        Point intersection = s1.getIntersection(s2).toPoint();
        return this.contains(intersection) && l.contains(intersection) ? intersection : null;
    }

    @Override
    protected Set<BezierCurve.IntervalPair> getIntersectionIntervalPairs(BezierCurve other, Set<Point> intersections) {
        if (other instanceof Line) {
            return this.getIntersectionIntervalPairs((Line)other, intersections);
        }
        return super.getIntersectionIntervalPairs(other, intersections);
    }

    protected Set<BezierCurve.IntervalPair> getIntersectionIntervalPairs(Line other, Set<Point> intersections) {
        Point poi;
        HashSet<BezierCurve.IntervalPair> intervalPairs = new HashSet<BezierCurve.IntervalPair>();
        Straight s1 = new Straight(this);
        Straight s2 = new Straight(other);
        Vector vi = s1.getIntersection(s2);
        if (vi != null && this.contains(poi = vi.toPoint()) && other.contains(poi)) {
            double param1 = s1.getParameterAt(vi);
            double param2 = s2.getParameterAt(vi);
            double d = param1 < 0.0 ? 0.0 : (param1 = param1 > 1.0 ? 1.0 : param1);
            param2 = param2 < 0.0 ? 0.0 : (param2 > 1.0 ? 1.0 : param2);
            intervalPairs.add(new BezierCurve.IntervalPair(this, new BezierCurve.Interval(param1, param1), other, new BezierCurve.Interval(param2, param2)));
        }
        return intervalPairs;
    }

    @Override
    public Point[] getIntersections(BezierCurve curve) {
        if (curve instanceof Line) {
            Point poi = this.getIntersection((Line)curve);
            if (poi != null) {
                return new Point[]{poi};
            }
            return new Point[0];
        }
        return super.getIntersections(curve);
    }

    public double getLength() {
        return this.getP1().getDistance(this.getP2());
    }

    @Override
    public Point[] getPoints() {
        return new Point[]{this.getP1(), this.getP2()};
    }

    @Override
    public Point getProjection(Point p) {
        if (this.getP1().equals(this.getP2())) {
            return this.getP1();
        }
        Straight s = new Straight(this);
        Point projected = s.getProjection(new Vector(p)).toPoint();
        if (Double.isNaN(projected.x) || Double.isNaN(projected.y) || Double.isInfinite(projected.x) || Double.isInfinite(projected.y)) {
            return p;
        }
        if (this.getP1().equals(this.getP2()) && (this.getP1().equals(projected) || this.getP2().equals(projected)) || this.getBounds().contains(projected)) {
            return projected;
        }
        return Point.nearest(projected, this.getPoints());
    }

    @Override
    public Line getTransformed(AffineTransform t) {
        return new Line(t.getTransformed(this.getPoints()));
    }

    @Override
    public boolean intersects(ICurve c) {
        if (c instanceof Line) {
            return this.intersects((Line)c);
        }
        return super.intersects(c);
    }

    public boolean intersects(Line l) {
        return this.getIntersection(l) != null;
    }

    @Override
    public boolean overlaps(BezierCurve c) {
        if (c instanceof Line) {
            return this.overlaps((Line)c);
        }
        Straight s = new Straight(this);
        Line[] lineArray = PointListUtils.toSegmentsArray(c.getPoints(), false);
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line seg = lineArray[n2];
            if (!s.equals(new Straight(seg))) {
                return false;
            }
            ++n2;
        }
        if (this.overlaps(new Line(c.getP1(), c.getP2()))) {
            return true;
        }
        return super.touches(c);
    }

    public boolean overlaps(Line l) {
        return this.touches(l) && !this.intersects(l);
    }

    public Line setLine(double x1, double y1, double x2, double y2) {
        this.setP1(new Point(x1, y1));
        this.setP2(new Point(x2, y2));
        return this;
    }

    public Line setLine(Line l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
        return this;
    }

    public Line setLine(Point p1, Point p2) {
        this.setLine(p1.x, p1.y, p2.x, p2.y);
        return this;
    }

    public Line setX1(double x1) {
        this.setP1(new Point(x1, this.getY1()));
        return this;
    }

    public Line setX2(double x2) {
        this.setP2(new Point(x2, this.getY2()));
        return this;
    }

    public Line setY1(double y1) {
        this.setP1(new Point(this.getX1(), y1));
        return this;
    }

    public Line setY2(double y2) {
        this.setP2(new Point(this.getX2(), y2));
        return this;
    }

    @Override
    public Path toPath() {
        Path path = new Path();
        path.moveTo(this.getX1(), this.getY1());
        path.lineTo(this.getX2(), this.getY2());
        return path;
    }

    @Override
    public String toString() {
        return "Line: (" + this.getX1() + ", " + this.getY1() + ") -> (" + this.getX2() + ", " + this.getY2() + ")";
    }

    @Override
    public boolean touches(IGeometry g) {
        if (g instanceof Line) {
            return this.touches((Line)g);
        }
        return super.touches(g);
    }

    public boolean touches(Line l) {
        Vector3D l2;
        boolean touches;
        Point p1 = this.getP1();
        Point p2 = this.getP2();
        boolean bl = touches = l.contains(p1) || l.contains(p2);
        if (touches || p1.equals(p2)) {
            return touches;
        }
        Point lp1 = l.getP1();
        Point lp2 = l.getP2();
        boolean bl2 = touches = this.contains(lp1) || this.contains(lp2);
        if (touches || lp1.equals(lp2)) {
            return touches;
        }
        Vector3D l1 = new Vector3D(p1).getCrossProduct(new Vector3D(p2));
        Point intersection = l1.getCrossProduct(l2 = new Vector3D(lp1).getCrossProduct(new Vector3D(lp2))).toPoint();
        return intersection != null && this.contains(intersection) && l.contains(intersection);
    }
}

