/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.utils;

import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.eclipse.gef4.geometry.planar.Arc;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.geometry.planar.QuadraticCurve;
import org.eclipse.gef4.geometry.planar.RoundedRectangle;

public class Geometry2Shape {
    public static javafx.scene.shape.Arc toArc(Arc arc) {
        return new javafx.scene.shape.Arc(arc.getX() + arc.getWidth() / 2.0, arc.getY() + arc.getHeight() / 2.0, arc.getWidth() / 2.0, arc.getHeight() / 2.0, arc.getStartAngle().deg(), arc.getAngularExtent().deg());
    }

    public static CubicCurve toCubicCurve(org.eclipse.gef4.geometry.planar.CubicCurve cubic) {
        return new CubicCurve(cubic.getX1(), cubic.getY1(), cubic.getCtrlX1(), cubic.getCtrlY1(), cubic.getCtrlX2(), cubic.getCtrlY2(), cubic.getX2(), cubic.getY2());
    }

    public static Ellipse toEllipse(org.eclipse.gef4.geometry.planar.Ellipse ellipse) {
        return new Ellipse(ellipse.getX() + ellipse.getWidth() / 2.0, ellipse.getY() + ellipse.getHeight() / 2.0, ellipse.getWidth() / 2.0, ellipse.getHeight() / 2.0);
    }

    public static Line toLine(org.eclipse.gef4.geometry.planar.Line line) {
        return new Line(line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    public static Path toPath(org.eclipse.gef4.geometry.planar.Path path) {
        Path fxPath = new Path(Geometry2Shape.toPathElements(path));
        fxPath.setFillRule(path.getWindingRule() == 0 ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        return fxPath;
    }

    public static PathElement[] toPathElements(org.eclipse.gef4.geometry.planar.Path path) {
        Path.Segment[] segments = path.getSegments();
        PathElement[] elements = new PathElement[segments.length];
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            switch (segments[i].getType()) {
                case 0: {
                    elements[i] = new MoveTo(points[0].x, points[0].y);
                    break;
                }
                case 1: {
                    elements[i] = new LineTo(points[0].x, points[0].y);
                    break;
                }
                case 2: {
                    elements[i] = new QuadCurveTo(points[0].x, points[0].y, points[1].x, points[1].y);
                    break;
                }
                case 3: {
                    elements[i] = new CubicCurveTo(points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
                    break;
                }
                case 4: {
                    elements[i] = new ClosePath();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Path.Segment: <" + segments[i] + ">");
                }
            }
            ++i;
        }
        return elements;
    }

    public static javafx.scene.shape.Polygon toPolygon(Polygon polygon) {
        return new javafx.scene.shape.Polygon(polygon.getCoordinates());
    }

    public static javafx.scene.shape.Polyline toPolyline(Polyline polyline) {
        return new javafx.scene.shape.Polyline(polyline.getCoordinates());
    }

    public static QuadCurve toQuadCurve(QuadraticCurve quadCurve) {
        return new QuadCurve(quadCurve.getX1(), quadCurve.getY1(), quadCurve.getCtrlX(), quadCurve.getCtrlY(), quadCurve.getX2(), quadCurve.getY2());
    }

    public static Rectangle toRectangle(org.eclipse.gef4.geometry.planar.Rectangle rect) {
        return new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle toRectangle(RoundedRectangle roundedRect) {
        Rectangle rectangle = new Rectangle(roundedRect.getX(), roundedRect.getY(), roundedRect.getWidth(), roundedRect.getHeight());
        rectangle.setArcWidth(roundedRect.getArcWidth());
        rectangle.setArcHeight(roundedRect.getArcHeight());
        return rectangle;
    }

    public static Shape toShape(IGeometry geometry) {
        if (geometry instanceof Arc) {
            return Geometry2Shape.toArc((Arc)geometry);
        }
        if (geometry instanceof org.eclipse.gef4.geometry.planar.CubicCurve) {
            return Geometry2Shape.toCubicCurve((org.eclipse.gef4.geometry.planar.CubicCurve)geometry);
        }
        if (geometry instanceof org.eclipse.gef4.geometry.planar.Ellipse) {
            return Geometry2Shape.toEllipse((org.eclipse.gef4.geometry.planar.Ellipse)geometry);
        }
        if (geometry instanceof org.eclipse.gef4.geometry.planar.Line) {
            return Geometry2Shape.toLine((org.eclipse.gef4.geometry.planar.Line)geometry);
        }
        if (geometry instanceof org.eclipse.gef4.geometry.planar.Path) {
            return Geometry2Shape.toPath((org.eclipse.gef4.geometry.planar.Path)geometry);
        }
        if (geometry instanceof Polygon) {
            return Geometry2Shape.toPolygon((Polygon)geometry);
        }
        if (geometry instanceof Polyline) {
            return Geometry2Shape.toPolyline((Polyline)geometry);
        }
        if (geometry instanceof QuadraticCurve) {
            QuadraticCurve quad = (QuadraticCurve)geometry;
            return Geometry2Shape.toQuadCurve(quad);
        }
        if (geometry instanceof org.eclipse.gef4.geometry.planar.Rectangle) {
            return Geometry2Shape.toRectangle((org.eclipse.gef4.geometry.planar.Rectangle)geometry);
        }
        if (geometry instanceof RoundedRectangle) {
            return Geometry2Shape.toRectangle((RoundedRectangle)geometry);
        }
        return Geometry2Shape.toPath(geometry.toPath());
    }
}

