/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.AbstractRouter;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class OrthogonalRouter
extends AbstractRouter {
    private static final double OFFSET = 15.0;

    private int findReferenceIndex(Connection connection, int anchorIndex, IGeometry anchorageGeometry, int step) {
        int startIndex;
        ObservableList<Point> points = connection.getPointsUnmodifiable();
        int i = startIndex = anchorIndex + step;
        while (!(step < 0 ? i < 0 : i >= points.size())) {
            Point point = (Point)points.get(i);
            if (!anchorageGeometry.contains(point)) {
                return i;
            }
            i += step;
        }
        return startIndex;
    }

    private IGeometry getAnchorageGeometry(Connection connection, int index) {
        IAnchor anchor = connection.getAnchor(index);
        if (anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != connection) {
            Node anchorage = anchor.getAnchorage();
            if (anchor instanceof DynamicAnchor) {
                IGeometry geometry = (IGeometry)((DynamicAnchor)anchor).getComputationParameter(connection.getAnchorKey(index), DynamicAnchor.AnchorageReferenceGeometry.class).get();
                return NodeUtils.sceneToLocal((Node)connection, NodeUtils.localToScene(anchorage, geometry));
            }
            return NodeUtils.sceneToLocal((Node)connection, NodeUtils.localToScene(anchorage, NodeUtils.getShapeOutline(anchorage)));
        }
        return null;
    }

    @Override
    protected Point getAnchoredReferencePoint(Connection connection, int index) {
        if (index < 0 || index >= connection.getPointsUnmodifiable().size()) {
            throw new IndexOutOfBoundsException();
        }
        IGeometry geometry = this.getAnchorageGeometry(connection, index);
        int referenceIndex = this.findReferenceIndex(connection, index, geometry, index < connection.getPointsUnmodifiable().size() - 1 ? 1 : -1);
        IGeometry referenceGeometry = this.getAnchorageGeometry(connection, referenceIndex);
        if (referenceGeometry != null && geometry != null) {
            double y2;
            double x2;
            Point endPointHint;
            if (index == 0) {
                Point startPointHint = connection.getStartPointHint();
                if (startPointHint != null) {
                    return NodeUtils.parentToLocal(connection.getCurve(), startPointHint);
                }
            } else if (index == connection.getPointsUnmodifiable().size() - 1 && (endPointHint = connection.getEndPointHint()) != null) {
                return NodeUtils.parentToLocal(connection.getCurve(), endPointHint);
            }
            Rectangle bounds = geometry.getBounds();
            Rectangle refBounds = referenceGeometry.getBounds();
            double x1 = Math.max(bounds.getX(), refBounds.getX());
            if (x1 <= (x2 = Math.min(bounds.getX() + bounds.getWidth(), refBounds.getX() + refBounds.getWidth()))) {
                return NodeUtils.parentToLocal(connection.getCurve(), new Point(x1 + (x2 - x1) / 2.0, refBounds.getY() > bounds.getY() + bounds.getHeight() ? refBounds.getY() : refBounds.getY() + refBounds.getHeight()));
            }
            double y1 = Math.max(bounds.getY(), refBounds.getY());
            if (y1 <= (y2 = Math.min(bounds.getY() + bounds.getHeight(), refBounds.getY() + refBounds.getHeight()))) {
                return NodeUtils.parentToLocal(connection.getCurve(), new Point(refBounds.getX() > bounds.getX() + bounds.getWidth() ? refBounds.getX() : refBounds.getX() + refBounds.getWidth(), y1 + (y2 - y1) / 2.0));
            }
            return NodeUtils.parentToLocal(connection.getCurve(), this.getNearestBoundsProjection(referenceGeometry, geometry.getBounds().getCenter()));
        }
        return NodeUtils.parentToLocal(connection.getCurve(), connection.getPoint(referenceIndex));
    }

    private Point getNearestBoundsProjection(IGeometry g, Point p) {
        Line[] outlineSegments = g.getBounds().getOutlineSegments();
        Point nearestProjection = null;
        double nearestDistance = 0.0;
        Line[] lineArray = outlineSegments;
        int n = outlineSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Line l = lineArray[n2];
            Point projection = l.getProjection(p);
            double distance = p.getDistance(projection);
            if (nearestProjection == null || distance < nearestDistance) {
                nearestDistance = distance;
                nearestProjection = projection;
            }
            ++n2;
        }
        return nearestProjection;
    }

    private Polygon[] getTriangles(Connection connection, int i) {
        Node anchorage = connection.getAnchor(i).getAnchorage();
        Bounds boundsInScene = anchorage.localToScene(anchorage.getLayoutBounds());
        Rectangle rectangle = FX2Geometry.toRectangle((Bounds)boundsInScene);
        Polygon top = new Polygon(new Point[]{rectangle.getTopLeft(), rectangle.getTopRight(), rectangle.getCenter()});
        Polygon bottom = new Polygon(new Point[]{rectangle.getBottomLeft(), rectangle.getBottomRight(), rectangle.getCenter()});
        Polygon left = new Polygon(new Point[]{rectangle.getTopLeft(), rectangle.getBottomLeft(), rectangle.getCenter()});
        Polygon right = new Polygon(new Point[]{rectangle.getTopRight(), rectangle.getBottomRight(), rectangle.getCenter()});
        return new Polygon[]{top, right, bottom, left};
    }

    private boolean isBottom(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[2].contains(point);
    }

    private boolean isLeft(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[3].contains(point);
    }

    private boolean isRight(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[1].contains(point);
    }

    private boolean isSufficientlyHorizontal(Vector currentDirection) {
        return Math.abs(currentDirection.y) < 0.5 && Math.abs(currentDirection.x) > Math.abs(currentDirection.y);
    }

    private boolean isSufficientlyVertical(Vector currentDirection) {
        return Math.abs(currentDirection.y) > Math.abs(currentDirection.x) && Math.abs(currentDirection.x) < 0.5;
    }

    private boolean isTop(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[0].contains(point);
    }

    private boolean isTopOrBottom(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[0].contains(point) || triangles[2].contains(point);
    }

    @Override
    public void route(Connection connection) {
        if (connection.getPointsUnmodifiable().size() < 2) {
            return;
        }
        ControlPointManipulator controlPointManipulator = new ControlPointManipulator(connection);
        controlPointManipulator.clearPoints();
        Vector inDirection = null;
        Vector outDirection = null;
        int i = 0;
        while (i < connection.getPointsUnmodifiable().size() - 1) {
            IAnchor anchor = connection.getAnchor(i);
            if (anchor instanceof DynamicAnchor) {
                this.updateComputationParameters(connection, i);
            }
            Point currentPoint = connection.getPoint(i);
            inDirection = outDirection;
            IAnchor nextAnchor = connection.getAnchor(i + 1);
            if (nextAnchor instanceof DynamicAnchor) {
                this.updateComputationParameters(connection, i + 1);
            }
            outDirection = new Vector(connection.getPoint(i), connection.getPoint(i + 1));
            if (Math.abs(outDirection.x) <= 0.05 && Math.abs(outDirection.y) <= 0.05) {
                outDirection = inDirection;
            } else if (!this.isSufficientlyHorizontal(outDirection) && !this.isSufficientlyVertical(outDirection)) {
                outDirection = this.routeNonOrthogonalSegment(connection, controlPointManipulator, inDirection, outDirection, i, currentPoint);
            }
            ++i;
        }
        controlPointManipulator.addPoints();
    }

    protected Vector routeNonOrthogonalSegment(Connection connection, ControlPointManipulator controlPointManipulator, Vector inDirection, Vector outDirection, int i, Point currentPoint) {
        controlPointManipulator.setRoutingData(i + 1, currentPoint, outDirection);
        Vector moveVertically = new Vector(0.0, outDirection.y);
        Vector moveHorizontally = new Vector(outDirection.x, 0.0);
        if (i == 0 && connection.isStartConnected() || i == connection.getPointsUnmodifiable().size() - 2 && connection.isEndConnected()) {
            if (i == 0 && i != connection.getPointsUnmodifiable().size() - 2) {
                outDirection = this.isTopOrBottom(connection, i, currentPoint) ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally);
            } else if (i != 0 && i == connection.getPointsUnmodifiable().size() - 2) {
                outDirection = this.isTopOrBottom(connection, i + 1, currentPoint.getTranslated(outDirection.x, outDirection.y)) ? controlPointManipulator.addRoutingPoint(moveHorizontally) : controlPointManipulator.addRoutingPoint(moveVertically);
            } else {
                boolean currentIsTopOrBottom = this.isTopOrBottom(connection, i, currentPoint);
                boolean nextIsTopOrBottom = this.isTopOrBottom(connection, i + 1, currentPoint.getTranslated(outDirection.x, outDirection.y));
                if (currentIsTopOrBottom && nextIsTopOrBottom) {
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, outDirection.y / 2.0, outDirection.x, outDirection.y / 2.0);
                } else if (!currentIsTopOrBottom && !nextIsTopOrBottom) {
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, outDirection.x / 2.0, 0.0, outDirection.x / 2.0, outDirection.y);
                } else {
                    outDirection = currentIsTopOrBottom ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally);
                }
            }
        } else {
            outDirection = inDirection == null ? controlPointManipulator.addRoutingPoint(moveHorizontally) : (inDirection.isHorizontal() ? (inDirection.x < 0.0 && outDirection.x < 0.0 || inDirection.x > 0.0 && outDirection.x > 0.0 ? controlPointManipulator.addRoutingPoint(moveHorizontally) : controlPointManipulator.addRoutingPoint(moveVertically)) : (inDirection.y < 0.0 && outDirection.y < 0.0 || inDirection.y > 0.0 && outDirection.y > 0.0 ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally)));
        }
        return outDirection;
    }

    protected Vector routeOrthogonalSegment(Connection connection, ControlPointManipulator controlPointManipulator, Vector currentDirection, int i, Point currentPoint) {
        if (i == 0 && connection.isStartConnected() && i != connection.getPointsUnmodifiable().size() - 2) {
            if (currentDirection.isVertical()) {
                boolean isLeft = this.isLeft(connection, i, currentPoint);
                boolean isRight = this.isRight(connection, i, currentPoint);
                boolean isBottom = this.isBottom(connection, i, currentPoint);
                boolean isTop = this.isTop(connection, i, currentPoint);
                if ((isLeft || isRight) && !isBottom && !isTop) {
                    double offset = isLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y);
                    currentDirection = new Vector(-offset, 0.0);
                }
            } else if (currentDirection.isHorizontal()) {
                boolean isLeft = this.isLeft(connection, i, currentPoint);
                boolean isRight = this.isRight(connection, i, currentPoint);
                boolean isBottom = this.isBottom(connection, i, currentPoint);
                boolean isTop = this.isTop(connection, i, currentPoint);
                if ((isTop || isBottom) && !isLeft && !isRight) {
                    double offset = isTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x, offset);
                    currentDirection = new Vector(0.0, -offset);
                }
            }
        } else if (i != 0 && i == connection.getPointsUnmodifiable().size() - 2 && connection.isEndConnected()) {
            if (currentDirection.isHorizontal()) {
                boolean isLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if ((isTop || isBottom) && !isLeft && !isRight) {
                    double offset = isTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x, offset);
                    currentDirection = new Vector(0.0, -offset);
                }
            } else if (currentDirection.isVertical()) {
                boolean isLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if ((isLeft || isRight) && !isTop && !isBottom) {
                    double offset = isLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y);
                    currentDirection = new Vector(-offset, 0.0);
                }
            }
        } else if (i == 0 && i == connection.getPointsUnmodifiable().size() - 2 && connection.isStartConnected() && connection.isEndConnected()) {
            if (currentDirection.isHorizontal()) {
                boolean isCurrentTop = this.isTop(connection, i, currentPoint);
                boolean isNextBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isCurrentBottom = this.isBottom(connection, i, currentPoint);
                boolean isNextTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (isCurrentTop && isNextBottom || isCurrentBottom && isNextTop) {
                    double offset = isCurrentTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x / 2.0, offset, currentDirection.x / 2.0, currentDirection.y - offset, currentDirection.x, currentDirection.y - offset);
                    currentDirection = new Vector(0.0, offset);
                }
            } else if (currentDirection.isVertical()) {
                boolean isCurrentLeft = this.isLeft(connection, i, currentPoint);
                boolean isNextRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isCurrentRight = this.isRight(connection, i, currentPoint);
                boolean isNextLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (isCurrentLeft && isNextRight || isCurrentRight && isNextLeft) {
                    double offset = isCurrentLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y / 2.0, currentDirection.x - offset, currentDirection.y / 2.0, currentDirection.x - offset, currentDirection.y);
                }
            }
        }
        return currentDirection;
    }

    @Override
    protected void updateComputationParameters(Connection connection, int index) {
        super.updateComputationParameters(connection, index);
        AnchorKey anchorKey = connection.getAnchorKey(index);
        IAnchor anchor = connection.getAnchor(index);
        if (index == 0 || index == connection.getPointsUnmodifiable().size() - 1) {
            Point neighborPoint = connection.getPoint(index == 0 ? index + 1 : index - 1);
            Point delta = neighborPoint.getDifference(NodeUtils.sceneToLocal((Node)connection, NodeUtils.localToScene(anchorKey.getAnchored(), (Point)((DynamicAnchor)anchor).getComputationParameter(anchorKey, DynamicAnchor.AnchoredReferencePoint.class).get())));
            Orientation hint = null;
            if (Math.abs(delta.x) < 5.0 && Math.abs(delta.x) < Math.abs(delta.y)) {
                hint = Orientation.VERTICAL;
            } else if (Math.abs(delta.y) < 5.0 && Math.abs(delta.y) < Math.abs(delta.x)) {
                hint = Orientation.HORIZONTAL;
            }
            ((DynamicAnchor)anchor).getComputationParameter(anchorKey, DynamicAnchor.PreferredOrientation.class).set(hint);
        }
    }

    @Override
    public boolean wasInserted(IAnchor anchor) {
        return anchor instanceof OrthogonalPolylineRouterAnchor;
    }

    protected static class ControlPointManipulator {
        private Connection connection;
        private Map<Integer, List<Point>> pointsToInsert = new HashMap<Integer, List<Point>>();
        private int index;
        private Vector direction;
        private Point point;
        private List<IAnchor> initialControlAnchors;

        public ControlPointManipulator(Connection c) {
            this.connection = c;
        }

        public void addPoints() {
            int pointsInserted = 0;
            for (int insertionIndex : this.pointsToInsert.keySet()) {
                for (Point pointToInsert : this.pointsToInsert.get(insertionIndex)) {
                    this.initialControlAnchors.add(insertionIndex + pointsInserted - 1, new OrthogonalPolylineRouterAnchor((Node)this.connection, pointToInsert));
                    ++pointsInserted;
                }
            }
            this.connection.setControlAnchors(this.initialControlAnchors);
        }

        public Vector addRoutingPoint(int index, Point point, double dx, double dy) {
            Point insertion = point.getTranslated(dx, dy);
            if (!this.pointsToInsert.containsKey(index)) {
                this.pointsToInsert.put(index, new ArrayList());
            }
            this.pointsToInsert.get(index).add(insertion);
            return new Vector(dx, dy);
        }

        public Vector addRoutingPoint(Vector delta) {
            this.direction = this.direction.getSubtracted(this.addRoutingPoint(this.index, this.point, delta.x, delta.y));
            return this.direction;
        }

        public void addRoutingPoints(int index, Point point, double ... deltas) {
            if (deltas == null) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got <null>.");
            }
            if (deltas.length == 0) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got 0.");
            }
            if (deltas.length % 2 != 0) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got " + deltas.length + ".");
            }
            if (!this.pointsToInsert.containsKey(index)) {
                this.pointsToInsert.put(index, new ArrayList());
            }
            int i = 0;
            while (i < deltas.length) {
                Point insertion = point.getTranslated(deltas[i], deltas[i + 1]);
                this.pointsToInsert.get(index).add(insertion);
                i += 2;
            }
        }

        public void clearPoints() {
            this.initialControlAnchors = new ArrayList<IAnchor>();
            for (IAnchor a : this.connection.getControlAnchors()) {
                if (a instanceof OrthogonalPolylineRouterAnchor) continue;
                this.initialControlAnchors.add(a);
            }
            this.connection.setControlAnchors(this.initialControlAnchors);
        }

        public void setRoutingData(int index, Point point, Vector direction) {
            this.index = index;
            this.point = point;
            this.direction = direction;
        }
    }

    private static class OrthogonalPolylineRouterAnchor
    extends StaticAnchor {
        public OrthogonalPolylineRouterAnchor(Node anchorage, Point referencePositionInAnchorageLocal) {
            super(anchorage, referencePositionInAnchorageLocal);
        }

        @Override
        public String toString() {
            return "OrthogonalRouterAnchor[referencePosition=" + this.getReferencePosition() + "]";
        }
    }
}

