/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class HoverOverlayImageView
extends Group {
    private SimpleObjectProperty<Image> baseImageProperty = new SimpleObjectProperty();
    private SimpleObjectProperty<Image> overlayImageProperty = new SimpleObjectProperty();
    private ImageView baseImageView;
    private ImageView overlayImageView;

    public HoverOverlayImageView() {
        this.createImageViews();
        this.registerHoverEffect();
        this.registerPropertyListeners();
    }

    public SimpleObjectProperty<Image> baseImageProperty() {
        return this.baseImageProperty;
    }

    protected void createImageViews() {
        this.baseImageView = new ImageView();
        this.overlayImageView = new ImageView();
        this.getChildren().addAll((Object[])new Node[]{this.baseImageView, this.overlayImageView});
        this.setBlendMode(BlendMode.SRC_OVER);
        this.overlayImageView.setOpacity(0.0);
        this.baseImageView.setOpacity(0.8);
    }

    public ImageView getBaseImageView() {
        return this.baseImageView;
    }

    public ImageView getOverlayImageView() {
        return this.overlayImageView;
    }

    public SimpleObjectProperty<Image> overlayImageProperty() {
        return this.overlayImageProperty;
    }

    protected void registerHoverEffect() {
        this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)HoverOverlayImageView.this.baseImageView.opacityProperty(), (Object)0), new KeyValue((WritableValue)HoverOverlayImageView.this.overlayImageView.opacityProperty(), (Object)1)})}).play();
            }
        });
        this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)HoverOverlayImageView.this.baseImageView.opacityProperty(), (Object)0.8), new KeyValue((WritableValue)HoverOverlayImageView.this.overlayImageView.opacityProperty(), (Object)0)})}).play();
            }
        });
    }

    protected void registerPropertyListeners() {
        this.baseImageProperty.addListener((ChangeListener)new ChangeListener<Image>(){

            public void changed(ObservableValue<? extends Image> observable, Image oldImage, Image newImage) {
                HoverOverlayImageView.this.setImage(HoverOverlayImageView.this.baseImageView, newImage);
            }
        });
        this.overlayImageProperty.addListener((ChangeListener)new ChangeListener<Image>(){

            public void changed(ObservableValue<? extends Image> observable, Image oldImage, Image newImage) {
                HoverOverlayImageView.this.setImage(HoverOverlayImageView.this.overlayImageView, newImage);
            }
        });
    }

    private void setImage(ImageView imageView, Image image) {
        imageView.setImage(image);
        imageView.setTranslateX(-image.getWidth() / 2.0);
        imageView.setTranslateY(-image.getHeight() / 2.0);
    }
}

