/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal.parser.validation;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef4.common.reflect.ReflectionUtils;
import org.eclipse.gef4.dot.internal.DotLanguageSupport;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowtypePackage;
import org.eclipse.gef4.dot.internal.parser.conversion.DotTerminalConverters;
import org.eclipse.gef4.dot.internal.parser.dot.AttrStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Attribute;
import org.eclipse.gef4.dot.internal.parser.dot.AttributeType;
import org.eclipse.gef4.dot.internal.parser.dot.DotGraph;
import org.eclipse.gef4.dot.internal.parser.dot.DotPackage;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeOp;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeRhsNode;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeRhsSubgraph;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeStmtNode;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeStmtSubgraph;
import org.eclipse.gef4.dot.internal.parser.dot.GraphType;
import org.eclipse.gef4.dot.internal.parser.dot.NodeStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Subgraph;
import org.eclipse.gef4.dot.internal.parser.layout.Layout;
import org.eclipse.gef4.dot.internal.parser.point.PointPackage;
import org.eclipse.gef4.dot.internal.parser.shape.ShapePackage;
import org.eclipse.gef4.dot.internal.parser.splines.Splines;
import org.eclipse.gef4.dot.internal.parser.splinetype.SplinetypePackage;
import org.eclipse.gef4.dot.internal.parser.style.EdgeStyle;
import org.eclipse.gef4.dot.internal.parser.style.NodeStyle;
import org.eclipse.gef4.dot.internal.parser.style.Style;
import org.eclipse.gef4.dot.internal.parser.style.StyleItem;
import org.eclipse.gef4.dot.internal.parser.style.StylePackage;
import org.eclipse.gef4.dot.internal.parser.validation.AbstractDotJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class DotJavaValidator
extends AbstractDotJavaValidator {
    @Check
    public void checkValidAttributeValue(Attribute attribute) {
        List<Diagnostic> diagnostics = this.validateAttributeValue(this.getContext(attribute), attribute.getName(), attribute.getValue());
        for (Diagnostic d : diagnostics) {
            if (d.getSeverity() == 4) {
                this.getMessageAcceptor().acceptError(d.getMessage(), (EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, attribute.getName(), new String[]{attribute.getValue()});
                continue;
            }
            if (d.getSeverity() == 2) {
                this.getMessageAcceptor().acceptWarning(d.getMessage(), (EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, attribute.getName(), new String[]{attribute.getValue()});
                continue;
            }
            if (d.getSeverity() != 1) continue;
            this.getMessageAcceptor().acceptInfo(d.getMessage(), (EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, attribute.getName(), new String[]{attribute.getValue()});
        }
    }

    private AttributeContext getContext(Attribute attribute) {
        if (DotJavaValidator.isEdgeAttribute(attribute)) {
            return AttributeContext.EDGE;
        }
        if (DotJavaValidator.isNodeAttribute(attribute)) {
            return AttributeContext.NODE;
        }
        if (DotJavaValidator.isGraphAttribute(attribute)) {
            return AttributeContext.GRAPH;
        }
        if (DotJavaValidator.isSubgraphAttribute(attribute)) {
            return AttributeContext.SUBGRAPH;
        }
        throw new IllegalArgumentException("Context of attribute could not be determined.");
    }

    public List<Diagnostic> validateAttributeValue(AttributeContext context, String name, String value) {
        String unquotedValue = DotTerminalConverters.unquote(value);
        if ("forcelabels".equals(name)) {
            return this.validateBooleanAttributeValue("forcelabels", unquotedValue);
        }
        if ("fixedsize".equals(name)) {
            return this.validateBooleanAttributeValue("fixedsize", unquotedValue);
        }
        if ("rankdir".equals(name)) {
            return this.validateEnumAttributeValue(DotLanguageSupport.RANKDIR_PARSER, name, unquotedValue, "rankdir");
        }
        if ("splines".equals(name)) {
            List<Diagnostic> booleanCaseFindings = this.validateBooleanAttributeValue(name, unquotedValue);
            List<Diagnostic> stringCaseFindings = this.validateStringAttributeValue(name, unquotedValue, "splines string", (Object[])Splines.values());
            if (booleanCaseFindings.isEmpty() || stringCaseFindings.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Diagnostic> combinedFindings = new ArrayList<Diagnostic>();
            combinedFindings.addAll(booleanCaseFindings);
            combinedFindings.addAll(stringCaseFindings);
            return combinedFindings;
        }
        if ("layout".equals(name)) {
            return this.validateStringAttributeValue(name, unquotedValue, "layout", (Object[])Layout.values());
        }
        if ("dir".equals(name)) {
            return this.validateEnumAttributeValue(DotLanguageSupport.DIRTYPE_PARSER, name, unquotedValue, "dirType");
        }
        if ("arrowhead".equals(name) || "arrowtail".equals(name)) {
            return this.validateObjectAttributeValue((IParser)DotLanguageSupport.ARROWTYPE_PARSER, DotLanguageSupport.ARROWTYPE_VALIDATOR, name, unquotedValue, ArrowtypePackage.Literals.ARROW_TYPE, "arrowType");
        }
        if ("arrowsize".equals(name)) {
            return this.validateDoubleAttributeValue(name, unquotedValue, 0.0);
        }
        if ("pos".equals(name)) {
            if (AttributeContext.NODE.equals((Object)context)) {
                return this.validateObjectAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotLanguageSupport.POINT_VALIDATOR, name, unquotedValue, PointPackage.Literals.POINT, "point");
            }
            if (AttributeContext.EDGE.equals((Object)context)) {
                return this.validateObjectAttributeValue((IParser)DotLanguageSupport.SPLINETYPE_PARSER, DotLanguageSupport.SPLINETYPE_VALIDATOR, name, unquotedValue, SplinetypePackage.Literals.SPLINE_TYPE, "splineType");
            }
        } else {
            if ("shape".equals(name)) {
                return this.validateObjectAttributeValue((IParser)DotLanguageSupport.SHAPE_PARSER, DotLanguageSupport.SHAPE_VALIDATOR, name, unquotedValue, ShapePackage.Literals.SHAPE, "shape");
            }
            if ("sides".equals(name)) {
                return this.validateIntAttributeValue(name, unquotedValue, 0);
            }
            if ("skew".equals(name)) {
                return this.validateDoubleAttributeValue(name, unquotedValue, -100.0);
            }
            if ("distortion".equals(name)) {
                return this.validateDoubleAttributeValue(name, unquotedValue, -100.0);
            }
            if ("width".equals(name)) {
                return this.validateDoubleAttributeValue(name, unquotedValue, 0.01);
            }
            if ("height".equals(name)) {
                return this.validateDoubleAttributeValue(name, unquotedValue, 0.02);
            }
            if ("style".equals(name) && !unquotedValue.isEmpty()) {
                List<Diagnostic> grammarFindings = this.validateObjectAttributeValue((IParser)DotLanguageSupport.STYLE_PARSER, DotLanguageSupport.STYLE_VALIDATOR, name, unquotedValue, StylePackage.Literals.STYLE, "style");
                if (!grammarFindings.isEmpty()) {
                    return grammarFindings;
                }
                IParseResult parseResult = DotLanguageSupport.STYLE_PARSER.parse(new StringReader(unquotedValue));
                Style style = (Style)parseResult.getRootASTElement();
                ArrayList<Diagnostic> findings = new ArrayList<Diagnostic>();
                if (AttributeContext.NODE.equals((Object)context)) {
                    for (StyleItem styleItem : style.getStyleItems()) {
                        findings.addAll(this.validateStringAttributeValue(name, styleItem.getName(), "style", (Object[])NodeStyle.values()));
                    }
                } else if (AttributeContext.EDGE.equals((Object)context)) {
                    for (StyleItem styleItem : style.getStyleItems()) {
                        findings.addAll(this.validateStringAttributeValue(name, styleItem.getName(), "style", (Object[])EdgeStyle.values()));
                    }
                }
                return findings;
            }
            if ("head_lp".equals(name) || "lp".equals(name) || "tail_lp".equals(name) || "xlp".equals(name)) {
                return this.validateObjectAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotLanguageSupport.POINT_VALIDATOR, name, unquotedValue, PointPackage.Literals.POINT, "point");
            }
        }
        return Collections.emptyList();
    }

    public static boolean isNodeAttribute(Attribute attribute) {
        if (DotJavaValidator.getAncestorOfType(attribute, NodeStmt.class) != null) {
            return true;
        }
        AttrStmt attrStmt = DotJavaValidator.getAncestorOfType(attribute, AttrStmt.class);
        return attrStmt != null && AttributeType.NODE.equals((Object)attrStmt.getType());
    }

    public static boolean isSubgraphAttribute(Attribute attribute) {
        if (DotJavaValidator.isEdgeAttribute(attribute) || DotJavaValidator.isNodeAttribute(attribute)) {
            return false;
        }
        return DotJavaValidator.getAncestorOfType(attribute, Subgraph.class) != null;
    }

    public static boolean isGraphAttribute(Attribute attribute) {
        return !DotJavaValidator.isEdgeAttribute(attribute) && !DotJavaValidator.isNodeAttribute(attribute) && !DotJavaValidator.isSubgraphAttribute(attribute);
    }

    public static boolean isEdgeAttribute(Attribute attribute) {
        if (DotJavaValidator.getAncestorOfType(attribute, EdgeStmtNode.class) != null || DotJavaValidator.getAncestorOfType(attribute, EdgeStmtSubgraph.class) != null) {
            return true;
        }
        AttrStmt attrStmt = DotJavaValidator.getAncestorOfType(attribute, AttrStmt.class);
        return attrStmt != null && AttributeType.EDGE.equals((Object)attrStmt.getType());
    }

    @Check
    public void checkEdgeOpCorrespondsToGraphType(EdgeRhsNode edgeRhsNode) {
        this.checkEdgeOpCorrespondsToGraphType(edgeRhsNode.getOp(), DotJavaValidator.getAncestorOfType(edgeRhsNode, DotGraph.class).getType());
    }

    @Check
    public void checkEdgeOpCorrespondsToGraphType(EdgeRhsSubgraph edgeRhsSubgraph) {
        this.checkEdgeOpCorrespondsToGraphType(edgeRhsSubgraph.getOp(), DotJavaValidator.getAncestorOfType(edgeRhsSubgraph, DotGraph.class).getType());
    }

    private void checkEdgeOpCorrespondsToGraphType(EdgeOp edgeOp, GraphType graphType) {
        boolean edgeDirected = edgeOp.equals((Object)EdgeOp.DIRECTED);
        boolean graphDirected = graphType.equals((Object)GraphType.DIGRAPH);
        if (graphDirected && !edgeDirected) {
            this.error("EdgeOp '--' may only be used in undirected graphs.", (EStructuralFeature)DotPackage.eINSTANCE.getEdgeRhs_Op());
        } else if (!graphDirected && edgeDirected) {
            this.error("EdgeOp '->' may only be used in directed graphs.", (EStructuralFeature)DotPackage.eINSTANCE.getEdgeRhs_Op());
        }
    }

    private static <T extends EObject> T getAncestorOfType(EObject eObject, Class<T> type) {
        EObject container = eObject.eContainer();
        while (container != null && !type.isAssignableFrom(container.getClass())) {
            container = container.eContainer();
        }
        return (T)container;
    }

    private List<Diagnostic> validateBooleanAttributeValue(String attributeName, String attributeValue) {
        DotLanguageSupport.IPrimitiveValueParseResult<Boolean> parseResult = DotLanguageSupport.BOOL_PARSER.parse(attributeValue);
        if (parseResult.hasSyntaxErrors()) {
            return Collections.singletonList(DotJavaValidator.createSyntacticAttributeValueProblem(attributeValue, "bool", this.getFormattedSyntaxErrorMessages(parseResult), attributeName));
        }
        return Collections.emptyList();
    }

    private static Diagnostic createSyntacticAttributeValueProblem(String attributeValue, String attributeTypeName, String parserMessage, String issueCode) {
        return new FeatureBasedDiagnostic(4, "The value '" + attributeValue + "' is not a syntactically correct " + attributeTypeName + ": " + parserMessage, null, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, CheckType.NORMAL, issueCode, new String[]{attributeValue});
    }

    private String getFormattedSyntaxErrorMessages(IParseResult parseResult) {
        StringBuilder sb = new StringBuilder();
        for (INode n : parseResult.getSyntaxErrors()) {
            String message = n.getSyntaxErrorMessage().getMessage();
            if (message.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1) + (message.endsWith(".") ? "" : "."));
        }
        return sb.toString();
    }

    private String getFormattedSyntaxErrorMessages(DotLanguageSupport.IPrimitiveValueParseResult<?> parseResult) {
        StringBuilder sb = new StringBuilder();
        for (Diagnostic d : parseResult.getSyntaxErrors()) {
            String message = d.getMessage();
            if (message.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1) + (message.endsWith(".") ? "" : "."));
        }
        return sb.toString();
    }

    private List<Diagnostic> validateDoubleAttributeValue(String attributeName, String attributeValue, double minValue) {
        DotLanguageSupport.IPrimitiveValueParseResult<Double> parseResult = DotLanguageSupport.DOUBLE_PARSER.parse(attributeValue);
        if (parseResult.hasSyntaxErrors()) {
            return Collections.singletonList(DotJavaValidator.createSyntacticAttributeValueProblem(attributeValue, "double", this.getFormattedSyntaxErrorMessages(parseResult), attributeName));
        }
        if (parseResult.getParsedValue() < minValue) {
            return Collections.singletonList(this.createSemanticAttributeValueProblem(4, attributeValue, "double", "Value may not be smaller than " + minValue + ".", attributeName));
        }
        return Collections.emptyList();
    }

    private List<Diagnostic> validateIntAttributeValue(String attributeName, String attributeValue, int minValue) {
        DotLanguageSupport.IPrimitiveValueParseResult<Integer> parseResult = DotLanguageSupport.INT_PARSER.parse(attributeValue);
        if (parseResult.hasSyntaxErrors()) {
            return Collections.singletonList(DotJavaValidator.createSyntacticAttributeValueProblem(attributeValue, "int", this.getFormattedSyntaxErrorMessages(parseResult), attributeName));
        }
        if (parseResult.getParsedValue() < minValue) {
            return Collections.singletonList(this.createSemanticAttributeValueProblem(4, attributeValue, "int", "Value may not be smaller than " + minValue + ".", attributeName));
        }
        return Collections.emptyList();
    }

    private String getFormattedValues(Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (Object value : new TreeSet<Object>(Arrays.asList(values))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'" + value + "'");
        }
        return sb.toString();
    }

    private List<Diagnostic> validateEnumAttributeValue(DotLanguageSupport.IPrimitiveValueParser<?> parser, String attributeName, String attributeValue, String attributeTypeName) {
        DotLanguageSupport.IPrimitiveValueParseResult<?> parseResult = parser.parse(attributeValue);
        if (parseResult.hasSyntaxErrors()) {
            return Collections.singletonList(DotJavaValidator.createSyntacticAttributeValueProblem(attributeValue, attributeTypeName, this.getFormattedSyntaxErrorMessages(parseResult), attributeName));
        }
        return Collections.emptyList();
    }

    private List<Diagnostic> validateStringAttributeValue(String attributeName, String attributeValue, String attributeTypeName, Object[] validValues) {
        Object[] objectArray = validValues;
        int n = validValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object validValue = objectArray[n2];
            if (validValue.toString().equals(attributeValue)) {
                return Collections.emptyList();
            }
            ++n2;
        }
        return Collections.singletonList(this.createSemanticAttributeValueProblem(4, attributeValue, attributeTypeName, "Value should be one of " + this.getFormattedValues(validValues) + ".", null));
    }

    private List<Diagnostic> validateObjectAttributeValue(IParser parser, AbstractDeclarativeValidator validator, final String attributeName, final String attributeValue, EClass attributeType, final String attributeTypeName) {
        IParseResult parseResult = parser.parse((Reader)new StringReader(attributeValue));
        if (parseResult.hasSyntaxErrors()) {
            return Collections.singletonList(DotJavaValidator.createSyntacticAttributeValueProblem(attributeValue, attributeTypeName, this.getFormattedSyntaxErrorMessages(parseResult), attributeName));
        }
        final ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (validator != null) {
            validator.setMessageAcceptor(new ValidationMessageAcceptor(){

                public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    diagnostics.add(DotJavaValidator.this.createSemanticAttributeValueProblem(4, attributeValue, attributeTypeName, message, attributeName));
                }

                public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
                    diagnostics.add(DotJavaValidator.this.createSemanticAttributeValueProblem(4, attributeValue, attributeTypeName, message, attributeName));
                }

                public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    diagnostics.add(DotJavaValidator.this.createSemanticAttributeValueProblem(1, attributeValue, attributeTypeName, message, attributeName));
                }

                public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
                    diagnostics.add(DotJavaValidator.this.createSemanticAttributeValueProblem(1, attributeValue, attributeTypeName, message, attributeName));
                }

                public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    diagnostics.add(DotJavaValidator.this.createSemanticAttributeValueProblem(2, attributeValue, attributeTypeName, message, attributeName));
                }

                public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
                    diagnostics.add(DotJavaValidator.this.createSemanticAttributeValueProblem(2, attributeValue, attributeTypeName, message, attributeName));
                }
            });
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ReflectionUtils.getPrivateFieldValue((Object)validator, (String)"languageName"));
            EObject root = parseResult.getRootASTElement();
            validator.validate(attributeType, root, null, context);
            TreeIterator iterator = EcoreUtil.getAllProperContents((EObject)root, (boolean)true);
            while (iterator.hasNext()) {
                validator.validate(attributeType, (EObject)iterator.next(), null, context);
            }
        }
        return diagnostics;
    }

    private Diagnostic createSemanticAttributeValueProblem(int severity, String attributeValue, String attributeTypeName, String validatorMessage, String issueCode) {
        return new FeatureBasedDiagnostic(severity, "The " + attributeTypeName + " value '" + attributeValue + "' is not semantically correct: " + validatorMessage, null, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, CheckType.NORMAL, issueCode, new String[]{attributeValue});
    }

    public static enum AttributeContext {
        GRAPH,
        SUBGRAPH,
        NODE,
        EDGE;

    }
}

