/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal.parser.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef4.dot.internal.parser.arrowtype.AbstractArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowType;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowtypePackage;
import org.eclipse.gef4.dot.internal.parser.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.PrimitiveShape;
import org.eclipse.gef4.dot.internal.parser.validation.AbstractDotArrowTypeJavaValidator;
import org.eclipse.xtext.validation.Check;

public class DotArrowTypeJavaValidator
extends AbstractDotArrowTypeJavaValidator {
    @Check
    public void checkOpenModifier(ArrowShape arrowShape) {
        PrimitiveShape shape = arrowShape.getShape();
        if (arrowShape.isOpen() && (PrimitiveShape.CROW.equals((Object)shape) || PrimitiveShape.CURVE.equals((Object)shape) || PrimitiveShape.ICURVE.equals((Object)shape) || PrimitiveShape.NONE.equals((Object)shape) || PrimitiveShape.TEE.equals((Object)shape) || PrimitiveShape.VEE.equals((Object)shape))) {
            this.warning("The open modifier 'o' may not be combined with primitive shape '" + (Object)((Object)shape) + "'.", (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__OPEN);
        }
    }

    @Check
    public void checkSideModifier(ArrowShape arrowShape) {
        PrimitiveShape shape = arrowShape.getShape();
        if (arrowShape.getSide() != null && (PrimitiveShape.DOT.equals((Object)shape) || PrimitiveShape.NONE.equals((Object)shape))) {
            this.warning("The side modifier '" + arrowShape.getSide() + "' may not be combined with primitive shape '" + (Object)((Object)shape) + "'.", (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__SIDE);
        }
    }

    @Check
    public void checkDeprecatedArrowShape(DeprecatedArrowShape arrowShape) {
        this.warning("The shape '" + (Object)((Object)arrowShape.getShape()) + "' is deprecated.", (EStructuralFeature)ArrowtypePackage.Literals.DEPRECATED_ARROW_SHAPE__SHAPE);
    }

    @Check
    public void checkIfNoneIsTheLastArrowShape(ArrowType arrowType) {
        AbstractArrowShape lastShape;
        int numberOfArrowShapes = arrowType.getArrowShapes().size();
        if (numberOfArrowShapes > 1 && (lastShape = (AbstractArrowShape)arrowType.getArrowShapes().get(numberOfArrowShapes - 1)) instanceof ArrowShape && ((ArrowShape)lastShape).getShape() == PrimitiveShape.NONE) {
            this.warning("The shape '" + (Object)((Object)PrimitiveShape.NONE) + "' may not be the last shape.", (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__SHAPE);
        }
    }
}

