/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef4.dot.internal.DotLanguageSupport;
import org.eclipse.gef4.dot.internal.parser.DotStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowType;
import org.eclipse.gef4.dot.internal.parser.dir.DirType;
import org.eclipse.gef4.dot.internal.parser.dot.GraphType;
import org.eclipse.gef4.dot.internal.parser.layout.Layout;
import org.eclipse.gef4.dot.internal.parser.point.Point;
import org.eclipse.gef4.dot.internal.parser.rankdir.Rankdir;
import org.eclipse.gef4.dot.internal.parser.shape.Shape;
import org.eclipse.gef4.dot.internal.parser.splines.Splines;
import org.eclipse.gef4.dot.internal.parser.splinetype.SplineType;
import org.eclipse.gef4.dot.internal.parser.style.Style;
import org.eclipse.gef4.dot.internal.parser.validation.DotJavaValidator;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.serializer.ISerializer;

public class DotAttributes {
    private static final Injector dotInjector = new DotStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final DotJavaValidator DOT_VALIDATOR = (DotJavaValidator)((Object)dotInjector.getInstance(DotJavaValidator.class));
    public static final String _NAME__GNE = "_name";
    public static final String _TYPE__G = "_type";
    public static final String _TYPE__G__DIGRAPH = GraphType.DIGRAPH.getLiteral();
    public static final String _TYPE__G__GRAPH = GraphType.GRAPH.getLiteral();
    public static final String ARROWHEAD__E = "arrowhead";
    public static final String ARROWSIZE__E = "arrowsize";
    public static final String ARROWTAIL__E = "arrowtail";
    public static final String DIR__E = "dir";
    public static final String DISTORTION__N = "distortion";
    public static final String FIXEDSIZE__N = "fixedsize";
    public static final String FORCELABELS__G = "forcelabels";
    public static final String HEAD_LP__E = "head_lp";
    public static final String HEADLABEL__E = "headlabel";
    public static final String HEIGHT__N = "height";
    public static final String ID__GNE = "id";
    public static final String LABEL__GNE = "label";
    public static final String LAYOUT__G = "layout";
    public static final String LP__GE = "lp";
    public static final String POS__NE = "pos";
    public static final String RANKDIR__G = "rankdir";
    public static final String SHAPE__N = "shape";
    public static final String SIDES__N = "sides";
    public static final String SKEW__N = "skew";
    public static final String SPLINES__G = "splines";
    public static final String STYLE__GNE = "style";
    public static final String TAIL_LP__E = "tail_lp";
    public static final String TAILLABEL__E = "taillabel";
    public static final String WIDTH__N = "width";
    public static final String XLABEL__NE = "xlabel";
    public static final String XLP__NE = "xlp";

    public static String _getName(Edge edge) {
        return (String)edge.attributesProperty().get((Object)_NAME__GNE);
    }

    public static String _getName(Graph graph) {
        return (String)graph.attributesProperty().get((Object)_NAME__GNE);
    }

    public static String _getName(Node node) {
        return (String)node.attributesProperty().get((Object)_NAME__GNE);
    }

    public static String _getType(Graph graph) {
        return (String)graph.attributesProperty().get((Object)_TYPE__G);
    }

    public static void _setName(Edge edge, String name) {
        edge.attributesProperty().put((Object)_NAME__GNE, (Object)name);
    }

    public static void _setName(Graph graph, String name) {
        graph.attributesProperty().put((Object)_NAME__GNE, (Object)name);
    }

    public static void _setName(Node node, String name) {
        node.attributesProperty().put((Object)_NAME__GNE, (Object)name);
    }

    public static void _setType(Graph graph, String type) {
        if (!_TYPE__G__GRAPH.equals(type) && !_TYPE__G__DIGRAPH.equals(type)) {
            throw new IllegalArgumentException("Cannot set graph attribute \"type\" to \"" + type + "\"; supported values: " + _TYPE__G__GRAPH + ", " + _TYPE__G__DIGRAPH);
        }
        graph.attributesProperty().put((Object)_TYPE__G, (Object)type);
    }

    private static List<Diagnostic> filter(List<Diagnostic> diagnostics, int severity) {
        ArrayList<Diagnostic> filtered = new ArrayList<Diagnostic>();
        for (Diagnostic d : diagnostics) {
            if (d.getSeverity() < severity) continue;
            filtered.add(d);
        }
        return filtered;
    }

    public static String getArrowHead(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ARROWHEAD__E);
    }

    public static ArrowType getArrowHeadParsed(Edge edge) {
        return (ArrowType)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.ARROWTYPE_PARSER, DotAttributes.getArrowHead(edge));
    }

    public static String getArrowSize(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ARROWSIZE__E);
    }

    public static Double getArrowSizeParsed(Edge edge) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.DOUBLE_PARSER, DotAttributes.getArrowSize(edge));
    }

    public static String getArrowTail(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ARROWTAIL__E);
    }

    public static ArrowType getArrowTailParsed(Edge edge) {
        return (ArrowType)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.ARROWTYPE_PARSER, DotAttributes.getArrowTail(edge));
    }

    public static String getDir(Edge edge) {
        return (String)edge.attributesProperty().get((Object)DIR__E);
    }

    public static DirType getDirParsed(Edge edge) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.DIRTYPE_PARSER, DotAttributes.getDir(edge));
    }

    public static String getDistortion(Node node) {
        return (String)node.attributesProperty().get((Object)DISTORTION__N);
    }

    public static Double getDistortionParsed(Node node) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.DOUBLE_PARSER, DotAttributes.getDistortion(node));
    }

    public static String getFixedSize(Node node) {
        return (String)node.attributesProperty().get((Object)FIXEDSIZE__N);
    }

    public static Boolean getFixedSizeParsed(Node node) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.BOOL_PARSER, DotAttributes.getFixedSize(node));
    }

    public static String getForceLabels(Graph graph) {
        return (String)graph.attributesProperty().get((Object)FORCELABELS__G);
    }

    public static Boolean getForceLabelsParsed(Graph graph) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.BOOL_PARSER, DotAttributes.getForceLabels(graph));
    }

    private static String getFormattedDiagnosticMessage(List<Diagnostic> diagnostics) {
        StringBuilder sb = new StringBuilder();
        for (Diagnostic n : diagnostics) {
            String message = n.getMessage();
            if (message.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(message);
        }
        return sb.toString();
    }

    public static String getHeadLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)HEADLABEL__E);
    }

    public static String getHeadLp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)HEAD_LP__E);
    }

    public static Point getHeadLpParsed(Edge edge) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getHeadLp(edge));
    }

    public static String getHeight(Node node) {
        return (String)node.attributesProperty().get((Object)HEIGHT__N);
    }

    public static Double getHeightParsed(Node node) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.DOUBLE_PARSER, DotAttributes.getHeight(node));
    }

    public static String getId(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ID__GNE);
    }

    public static String getId(Graph graph) {
        return (String)graph.attributesProperty().get((Object)ID__GNE);
    }

    public static String getId(Node node) {
        return (String)node.attributesProperty().get((Object)ID__GNE);
    }

    public static String getLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)LABEL__GNE);
    }

    public static String getLabel(Graph graph) {
        return (String)graph.attributesProperty().get((Object)LABEL__GNE);
    }

    public static String getLabel(Node node) {
        return (String)node.attributesProperty().get((Object)LABEL__GNE);
    }

    public static String getLayout(Graph graph) {
        return (String)graph.attributesProperty().get((Object)LAYOUT__G);
    }

    public static Layout getLayoutParsed(Graph graph) {
        return Layout.get(DotAttributes.getLayout(graph));
    }

    public static String getLp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)LP__GE);
    }

    public static String getLp(Graph graph) {
        return (String)graph.attributesProperty().get((Object)LP__GE);
    }

    public static Point getLpParsed(Edge edge) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getLp(edge));
    }

    public static Point getLpParsed(Graph graph) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getLp(graph));
    }

    public static String getPos(Edge edge) {
        return (String)edge.attributesProperty().get((Object)POS__NE);
    }

    public static String getPos(Node node) {
        return (String)node.attributesProperty().get((Object)POS__NE);
    }

    public static SplineType getPosParsed(Edge edge) {
        return (SplineType)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.SPLINETYPE_PARSER, DotAttributes.getPos(edge));
    }

    public static Point getPosParsed(Node node) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getPos(node));
    }

    public static String getRankdir(Graph graph) {
        return (String)graph.attributesProperty().get((Object)RANKDIR__G);
    }

    public static Rankdir getRankdirParsed(Graph graph) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.RANKDIR_PARSER, DotAttributes.getRankdir(graph));
    }

    public static String getShape(Node node) {
        return (String)node.attributesProperty().get((Object)SHAPE__N);
    }

    public static Shape getShapeParsed(Node node) {
        return (Shape)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.SHAPE_PARSER, DotAttributes.getShape(node));
    }

    public static String getSides(Node node) {
        return (String)node.attributesProperty().get((Object)SIDES__N);
    }

    public static Integer getSidesParsed(Node node) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.INT_PARSER, DotAttributes.getSides(node));
    }

    public static String getSkew(Node node) {
        return (String)node.attributesProperty().get((Object)SKEW__N);
    }

    public static Double getSkewParsed(Node node) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.DOUBLE_PARSER, DotAttributes.getSkew(node));
    }

    public static String getSplines(Graph graph) {
        return (String)graph.attributesProperty().get((Object)SPLINES__G);
    }

    public static Splines getSplinesParsed(Graph graph) {
        return Splines.get(DotAttributes.getSplines(graph));
    }

    public static String getStyle(Edge edge) {
        return (String)edge.attributesProperty().get((Object)STYLE__GNE);
    }

    public static String getStyle(Node node) {
        return (String)node.attributesProperty().get((Object)STYLE__GNE);
    }

    public static Style getStyleParsed(Edge edge) {
        return (Style)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.STYLE_PARSER, DotAttributes.getStyle(edge));
    }

    public static Style getStyleParsed(Node node) {
        return (Style)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.STYLE_PARSER, DotAttributes.getStyle(node));
    }

    public static String getTailLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)TAILLABEL__E);
    }

    public static String getTailLp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)TAIL_LP__E);
    }

    public static Point getTailLpParsed(Edge edge) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getTailLp(edge));
    }

    public static String getWidth(Node node) {
        return (String)node.attributesProperty().get((Object)WIDTH__N);
    }

    public static Double getWidthParsed(Node node) {
        return DotLanguageSupport.parseAttributeValue(DotLanguageSupport.DOUBLE_PARSER, DotAttributes.getWidth(node));
    }

    public static String getXLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)XLABEL__NE);
    }

    public static String getXLabel(Node node) {
        return (String)node.attributesProperty().get((Object)XLABEL__NE);
    }

    public static String getXlp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)XLP__NE);
    }

    public static String getXlp(Node node) {
        return (String)node.attributesProperty().get((Object)XLP__NE);
    }

    public static Point getXlpParsed(Edge edge) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getXlp(edge));
    }

    public static Point getXlpParsed(Node node) {
        return (Point)DotLanguageSupport.parseAttributeValue((IParser)DotLanguageSupport.POINT_PARSER, DotAttributes.getXlp(node));
    }

    private static <T extends EObject> String serialize(ISerializer serializer, T parsedValue) {
        if (parsedValue == null) {
            return null;
        }
        return serializer.serialize(parsedValue);
    }

    public static void setArrowHead(Edge edge, String arrowHead) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, ARROWHEAD__E, arrowHead);
        edge.attributesProperty().put((Object)ARROWHEAD__E, (Object)arrowHead);
    }

    public static void setArrowHeadParsed(Edge edge, ArrowType arrowHeadParsed) {
        DotAttributes.setArrowHead(edge, DotAttributes.serialize(DotLanguageSupport.ARROWTYPE_SERIALIZER, arrowHeadParsed));
    }

    public static void setArrowSize(Edge edge, String arrowSize) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, ARROWSIZE__E, arrowSize);
        edge.attributesProperty().put((Object)ARROWSIZE__E, (Object)arrowSize);
    }

    public static void setArrowSizeParsed(Edge edge, Double arrowSizeParsed) {
        DotAttributes.setArrowSize(edge, arrowSizeParsed.toString());
    }

    public static void setArrowTail(Edge edge, String arrowTail) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, ARROWTAIL__E, arrowTail);
        edge.attributesProperty().put((Object)ARROWTAIL__E, (Object)arrowTail);
    }

    public static void setArrowTailParsed(Edge edge, ArrowType arrowTailParsed) {
        DotAttributes.setArrowTail(edge, DotAttributes.serialize(DotLanguageSupport.ARROWTYPE_SERIALIZER, arrowTailParsed));
    }

    public static void setDir(Edge edge, String dir) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, DIR__E, dir);
        edge.attributesProperty().put((Object)DIR__E, (Object)dir);
    }

    public static void setDirParsed(Edge edge, DirType dirParsed) {
        DotAttributes.setDir(edge, dirParsed.toString());
    }

    public static void setDistortion(Node node, String distortion) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, DISTORTION__N, distortion);
        node.attributesProperty().put((Object)DISTORTION__N, (Object)distortion);
    }

    public static void setDistortionParsed(Node node, Double distortionParsed) {
        DotAttributes.setDistortion(node, distortionParsed.toString());
    }

    public static void setFixedSize(Node node, String fixedSize) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, FIXEDSIZE__N, fixedSize);
        node.attributesProperty().put((Object)FIXEDSIZE__N, (Object)fixedSize);
    }

    public static void setFixedSizeParsed(Node node, Boolean fixedSizeParsed) {
        DotAttributes.setFixedSize(node, fixedSizeParsed.toString());
    }

    public static void setForceLabels(Graph graph, String forceLabels) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.GRAPH, FORCELABELS__G, forceLabels);
        graph.attributesProperty().put((Object)FORCELABELS__G, (Object)forceLabels);
    }

    public static void setForceLabelsParsed(Graph graph, Boolean forceLabelsParsed) {
        DotAttributes.setForceLabels(graph, forceLabelsParsed.toString());
    }

    public static void setHeadLabel(Edge edge, String headLabel) {
        edge.attributesProperty().put((Object)HEADLABEL__E, (Object)headLabel);
    }

    public static void setHeadLp(Edge edge, String headLp) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, HEAD_LP__E, headLp);
        edge.attributesProperty().put((Object)HEAD_LP__E, (Object)headLp);
    }

    public static void setHeadLpParsed(Edge edge, Point headLpParsed) {
        DotAttributes.setHeadLp(edge, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, headLpParsed));
    }

    public static void setHeight(Node node, String height) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, HEIGHT__N, height);
        node.attributesProperty().put((Object)HEIGHT__N, (Object)height);
    }

    public static void setHeightParsed(Node node, Double heightParsed) {
        DotAttributes.setHeight(node, heightParsed.toString());
    }

    public static void setId(Edge edge, String id) {
        edge.attributesProperty().put((Object)ID__GNE, (Object)id);
    }

    public static void setId(Graph graph, String id) {
        graph.attributesProperty().put((Object)ID__GNE, (Object)id);
    }

    public static void setId(Node node, String id) {
        node.attributesProperty().put((Object)ID__GNE, (Object)id);
    }

    public static void setLabel(Edge edge, String label) {
        edge.attributesProperty().put((Object)LABEL__GNE, (Object)label);
    }

    public static void setLabel(Graph graph, String label) {
        graph.attributesProperty().put((Object)LABEL__GNE, (Object)label);
    }

    public static void setLabel(Node node, String label) {
        node.attributesProperty().put((Object)LABEL__GNE, (Object)label);
    }

    public static void setLayout(Graph graph, String layout) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.GRAPH, LAYOUT__G, layout);
        graph.attributesProperty().put((Object)LAYOUT__G, (Object)layout);
    }

    public static void setLayoutParsed(Graph graph, Layout layoutParsed) {
        DotAttributes.setLayout(graph, layoutParsed.toString());
    }

    public static void setLp(Edge edge, String lp) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, LP__GE, lp);
        edge.attributesProperty().put((Object)LP__GE, (Object)lp);
    }

    public static void setLp(Graph graph, String lp) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.GRAPH, LP__GE, lp);
        graph.attributesProperty().put((Object)LP__GE, (Object)lp);
    }

    public static void setLpParsed(Edge edge, Point lpParsed) {
        DotAttributes.setLp(edge, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, lpParsed));
    }

    public static void setLpParsed(Graph graph, Point lpParsed) {
        DotAttributes.setLp(graph, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, lpParsed));
    }

    public static void setPos(Edge edge, String pos) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, POS__NE, pos);
        edge.attributesProperty().put((Object)POS__NE, (Object)pos);
    }

    public static void setPos(Node node, String pos) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, POS__NE, pos);
        node.attributesProperty().put((Object)POS__NE, (Object)pos);
    }

    public static void setPosParsed(Edge edge, SplineType posParsed) {
        DotAttributes.setPos(edge, DotAttributes.serialize(DotLanguageSupport.SPLINETYPE_SERIALIZER, posParsed));
    }

    public static void setPosParsed(Node node, Point posParsed) {
        DotAttributes.setPos(node, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, posParsed));
    }

    public static void setRankdir(Graph graph, String rankdir) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.GRAPH, RANKDIR__G, rankdir);
        graph.attributesProperty().put((Object)RANKDIR__G, (Object)rankdir);
    }

    public static void setRankdirParsed(Graph graph, Rankdir rankdirParsed) {
        DotAttributes.setRankdir(graph, rankdirParsed.toString());
    }

    public static void setShape(Node node, String shape) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, SHAPE__N, shape);
        node.attributesProperty().put((Object)SHAPE__N, (Object)shape);
    }

    public static void setShapeParsed(Node node, Shape shapeParsed) {
        DotAttributes.setShape(node, DotAttributes.serialize(DotLanguageSupport.SHAPE_SERIALIZER, shapeParsed));
    }

    public static void setSides(Node node, String sides) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, SIDES__N, sides);
        node.attributesProperty().put((Object)SIDES__N, (Object)sides);
    }

    public static void setSidesParsed(Node node, Integer sidesParsed) {
        DotAttributes.setSides(node, sidesParsed.toString());
    }

    public static void setSkew(Node node, String skew) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, SKEW__N, skew);
        node.attributesProperty().put((Object)SKEW__N, (Object)skew);
    }

    public static void setSkewParsed(Node node, Double skewParsed) {
        DotAttributes.setSkew(node, skewParsed.toString());
    }

    public static void setSplines(Graph graph, String splines) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.GRAPH, SPLINES__G, splines);
        graph.attributesProperty().put((Object)SPLINES__G, (Object)splines);
    }

    public static void setSplinesParsed(Graph graph, Splines splinesParsed) {
        DotAttributes.setSplines(graph, splinesParsed.toString());
    }

    public static void setStyle(Edge edge, String style) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, STYLE__GNE, style);
        edge.attributesProperty().put((Object)STYLE__GNE, (Object)style);
    }

    public static void setStyle(Node node, String style) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, STYLE__GNE, style);
        node.attributesProperty().put((Object)STYLE__GNE, (Object)style);
    }

    public static void setStyleParsed(Edge edge, Style styleParsed) {
        DotAttributes.setStyle(edge, DotAttributes.serialize(DotLanguageSupport.STYLE_SERIALIZER, styleParsed));
    }

    public static void setStyleParsed(Node node, Style styleParsed) {
        DotAttributes.setStyle(node, DotAttributes.serialize(DotLanguageSupport.STYLE_SERIALIZER, styleParsed));
    }

    public static void setTailLabel(Edge edge, String tailLabel) {
        edge.attributesProperty().put((Object)TAILLABEL__E, (Object)tailLabel);
    }

    public static void setTailLp(Edge edge, String tailLp) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, TAIL_LP__E, tailLp);
        edge.attributesProperty().put((Object)TAIL_LP__E, (Object)tailLp);
    }

    public static void setTailLpParsed(Edge edge, Point tailLpParsed) {
        DotAttributes.setTailLp(edge, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, tailLpParsed));
    }

    public static void setWidth(Node node, String width) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, WIDTH__N, width);
        node.attributesProperty().put((Object)WIDTH__N, (Object)width);
    }

    public static void setWidthParsed(Node node, Double widthParsed) {
        DotAttributes.setWidth(node, widthParsed.toString());
    }

    public static void setXLabel(Edge edge, String xLabel) {
        edge.attributesProperty().put((Object)XLABEL__NE, (Object)xLabel);
    }

    public static void setXLabel(Node node, String xLabel) {
        node.attributesProperty().put((Object)XLABEL__NE, (Object)xLabel);
    }

    public static void setXlp(Edge edge, String xlp) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.EDGE, XLP__NE, xlp);
        edge.attributesProperty().put((Object)XLP__NE, (Object)xlp);
    }

    public static void setXlp(Node node, String xlp) {
        DotAttributes.validate(DotJavaValidator.AttributeContext.NODE, XLP__NE, xlp);
        node.attributesProperty().put((Object)XLP__NE, (Object)xlp);
    }

    public static void setXlpParsed(Edge edge, Point xlpParsed) {
        DotAttributes.setXlp(edge, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, xlpParsed));
    }

    public static void setXlpParsed(Node node, Point xlpParsed) {
        DotAttributes.setXlp(node, DotAttributes.serialize(DotLanguageSupport.POINT_SERIALIZER, xlpParsed));
    }

    private static void validate(DotJavaValidator.AttributeContext context, String attributeName, String attributeValue) {
        List<Diagnostic> diagnostics = DotAttributes.filter(DOT_VALIDATOR.validateAttributeValue(context, attributeName, attributeValue), 4);
        if (!diagnostics.isEmpty()) {
            throw new IllegalArgumentException("Cannot set " + context.name().toLowerCase() + " attribute '" + attributeName + "' to '" + attributeValue + "'. " + DotAttributes.getFormattedDiagnosticMessage(diagnostics));
        }
    }
}

