/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.swt;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import org.eclipse.swt.graphics.PathData;

public class SWT2AWT {
    public static PathIterator toAWTPathIterator(PathData pathData, int windingRule) {
        if (windingRule != 2 && windingRule != 1) {
            throw new IllegalArgumentException("Unsupported winding rule. Must be one of SWT.FILL_WINDING or SWT.FILL_EVEN_ODD");
        }
        Path2D.Double path = new Path2D.Double(windingRule == 1 ? 0 : 1);
        int j = 0;
        byte[] types = pathData.types;
        float[] points = pathData.points;
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    double x = points[j++];
                    double y = points[j++];
                    path.moveTo(x, y);
                    break;
                }
                case 2: {
                    double x = points[j++];
                    double y = points[j++];
                    path.lineTo(x, y);
                    break;
                }
                case 3: {
                    double x = points[j++];
                    double y = points[j++];
                    double x2 = points[j++];
                    double y2 = points[j++];
                    path.quadTo(x, y, x2, y2);
                    break;
                }
                case 4: {
                    double x = points[j++];
                    double y = points[j++];
                    double x2 = points[j++];
                    double y2 = points[j++];
                    double x3 = points[j++];
                    double y3 = points[j++];
                    path.curveTo(x, y, x2, y2, x3, y3);
                    break;
                }
                case 5: {
                    path.closePath();
                    break;
                }
            }
            ++i;
        }
        return path.getPathIterator(null);
    }

    private SWT2AWT() {
    }
}

