/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.nodes.AbstractRouter;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;

public class StraightRouter
extends AbstractRouter {
    @Override
    protected Point getAnchoredReferencePoint(Connection connection, int index) {
        if (index < 0 || index >= connection.getPointsUnmodifiable().size()) {
            throw new IndexOutOfBoundsException();
        }
        Point newRef = null;
        Point pred = this.getPred(connection, index);
        Point succ = this.getSucc(connection, index);
        newRef = pred == null && succ == null ? new Point() : (pred != null ? pred : (succ != null ? succ : new Line(pred, succ).get(0.5)));
        return newRef;
    }

    private Point getCenter(Connection connection, Node anchorageNode) {
        Point center = FX2Geometry.toRectangle((Bounds)connection.getCurve().sceneToLocal(anchorageNode.localToScene(anchorageNode.getLayoutBounds()))).getCenter();
        if (Double.isNaN(center.x) || Double.isNaN(center.y)) {
            return null;
        }
        return center;
    }

    private Point getNeighbor(Connection connection, int anchorIndex, int step) {
        ObservableList<IAnchor> anchors = connection.getAnchorsUnmodifiable();
        IAnchor anchor = (IAnchor)anchors.get(anchorIndex);
        if (!(anchor instanceof DynamicAnchor)) {
            throw new IllegalStateException("Specified anchor '" + anchor + "' is no DynamicAnchor.");
        }
        Node anchorage = anchor.getAnchorage();
        int i = anchorIndex + step;
        while (i < anchors.size() && i >= 0) {
            IAnchor predAnchor = (IAnchor)anchors.get(i);
            if (predAnchor == null) {
                throw new IllegalStateException("connection inconsistent (null anchor)");
            }
            Node predAnchorage = predAnchor.getAnchorage();
            if (predAnchorage == null || predAnchorage == connection) {
                AnchorKey anchorKey = connection.getAnchorKey(i);
                Point position = predAnchor.getPosition(anchorKey);
                if (position == null) {
                    throw new IllegalStateException("connection inconsistent (null position)");
                }
                Point2D local = anchorage.sceneToLocal(anchorKey.getAnchored().localToScene(position.x, position.y));
                if (!anchorage.contains(local)) {
                    return position;
                }
            } else {
                Point position = this.getCenter(connection, predAnchorage);
                if (position == null) {
                    throw new IllegalStateException("cannot determine anchorage center");
                }
                return position;
            }
            i += step;
        }
        return null;
    }

    private Point getPred(Connection connection, int anchorIndex) {
        return this.getNeighbor(connection, anchorIndex, -1);
    }

    private Point getSucc(Connection connection, int anchorIndex) {
        return this.getNeighbor(connection, anchorIndex, 1);
    }

    @Override
    public void route(Connection connection) {
        if (connection.getPointsUnmodifiable().size() < 2) {
            return;
        }
        ObservableList<IAnchor> anchors = connection.getAnchorsUnmodifiable();
        int i = 0;
        while (i < anchors.size()) {
            if (anchors.get(i) instanceof DynamicAnchor) {
                this.updateComputationParameters(connection, i);
            }
            ++i;
        }
    }

    @Override
    public boolean wasInserted(IAnchor anchor) {
        return false;
    }
}

