/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.viewer;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.inject.AdaptableScopes;
import org.eclipse.gef4.common.inject.AdapterMap;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractViewer<VR>
implements IViewer<VR>,
IAdaptable.Bound<IDomain<VR>> {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this, this.pcs);
    private AdaptableSupport<IViewer<VR>> ads = new AdaptableSupport((IAdaptable)this, this.pcs);
    private Map<Object, IContentPart<VR, ? extends VR>> contentsToContentPartMap = new IdentityHashMap<Object, IContentPart<VR, ? extends VR>>();
    private Map<VR, IVisualPart<VR, ? extends VR>> visualsToVisualPartMap = new HashMap<VR, IVisualPart<VR, ? extends VR>>();
    private IDomain<VR> domain;

    public AbstractViewer() {
        AdaptableScopes.enter((IAdaptable)this);
    }

    public void activate() {
        if (!this.acs.isActive()) {
            if (this.domain == null) {
                throw new IllegalStateException("Domain has to be set before activation.");
            }
            this.acs.activate();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void deactivate() {
        if (this.acs.isActive()) {
            if (this.domain == null) {
                throw new IllegalStateException("Domain may not be unset before deactivation is completed.");
            }
            this.acs.deactivate();
        }
    }

    public void dispose() {
        AdaptableScopes.leave((IAdaptable)this);
        this.ads.dispose();
    }

    public IDomain<VR> getAdaptable() {
        return this.domain;
    }

    public <T> T getAdapter(AdapterKey<? super T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<? super T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<? super T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public Map<Object, IContentPart<VR, ? extends VR>> getContentPartMap() {
        return this.contentsToContentPartMap;
    }

    @Override
    public IDomain<VR> getDomain() {
        return this.domain;
    }

    @Override
    public IRootPart<VR, ? extends VR> getRootPart() {
        return (IRootPart)this.ads.getAdapter(IRootPart.class);
    }

    @Override
    public Map<VR, IVisualPart<VR, ? extends VR>> getVisualPartMap() {
        return this.visualsToVisualPartMap;
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setAdaptable(IDomain<VR> domain) {
        if (this.domain == domain) {
            return;
        }
        this.domain = domain;
    }

    public <T> void setAdapter(AdapterKey<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    public <T> void setAdapter(Class<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    public <T> void setAdapter(TypeToken<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    @Inject(optional=true)
    public void setAdapters(@AdapterMap Map<AdapterKey<?>, Object> adaptersWithKeys) {
        this.ads.setAdapters(adaptersWithKeys, false);
    }

    public <T> T unsetAdapter(AdapterKey<? super T> key) {
        return (T)this.ads.unsetAdapter(key);
    }
}

