/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class ChangeSelectionOperation<VR>
extends AbstractOperation {
    public static final String DEFAULT_LABEL = "Change Selection";
    private IViewer<VR> viewer;
    private List<IContentPart<VR, ? extends VR>> oldSelection;
    private List<IContentPart<VR, ? extends VR>> newSelection;

    public ChangeSelectionOperation(IViewer<VR> viewer, List<IContentPart<VR, ? extends VR>> newSelection) {
        this(DEFAULT_LABEL, viewer, ((SelectionModel)viewer.getAdapter(SelectionModel.class)).getSelected(), newSelection);
    }

    public ChangeSelectionOperation(IViewer<VR> viewer, List<IContentPart<VR, ? extends VR>> oldSelection, List<IContentPart<VR, ? extends VR>> newSelection) {
        this(DEFAULT_LABEL, viewer, oldSelection, newSelection);
    }

    public ChangeSelectionOperation(String label, IViewer<VR> viewer, List<IContentPart<VR, ? extends VR>> oldSelection, List<IContentPart<VR, ? extends VR>> newSelection) {
        super(label);
        this.viewer = viewer;
        this.oldSelection = new ArrayList<IContentPart<VR, VR>>(oldSelection);
        this.newSelection = new ArrayList<IContentPart<VR, VR>>(newSelection);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(SelectionModel.class);
        selectionModel.deselectAll();
        selectionModel.select(this.newSelection);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(SelectionModel.class);
        selectionModel.deselectAll();
        selectionModel.select(this.oldSelection);
        return Status.OK_STATUS;
    }
}

