/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.geometry.planar.AffineTransform;

public class ViewportModel
implements IPropertyChangeNotifier {
    public static final String VIEWPORT_TRANSLATE_X_PROPERTY = "viewportTranslateX";
    public static final String VIEWPORT_TRANSLATE_Y_PROPERTY = "viewportTranslateY";
    public static final String VIEWPORT_WIDTH_PROPERTY = "viewportWidth";
    public static final String VIEWPORT_HEIGHT_PROPERTY = "viewportHeight";
    public static final String VIEWPORT_CONTENTS_TRANSFORM_PROPERTY = "viewportContentsTransform";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private double x = 0.0;
    private double y = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private AffineTransform contentsTx = new AffineTransform();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public AffineTransform getContentsTransform() {
        return this.contentsTx.getCopy();
    }

    public double getHeight() {
        return this.height;
    }

    public double getTranslateX() {
        return this.x;
    }

    public double getTranslateY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setContentsTransform(AffineTransform contentsTransform) {
        if (!this.contentsTx.equals((Object)contentsTransform)) {
            AffineTransform oldTx = this.contentsTx.getCopy();
            this.contentsTx = contentsTransform.getCopy();
            this.pcs.firePropertyChange(VIEWPORT_CONTENTS_TRANSFORM_PROPERTY, oldTx, this.contentsTx);
        }
    }

    public void setHeight(double height) {
        double oldHeight = this.height;
        this.height = height;
        if (oldHeight != height) {
            this.pcs.firePropertyChange(VIEWPORT_HEIGHT_PROPERTY, oldHeight, height);
        }
    }

    public void setTranslateX(double x) {
        double oldX = this.x;
        this.x = x;
        if (oldX != x) {
            this.pcs.firePropertyChange(VIEWPORT_TRANSLATE_X_PROPERTY, oldX, x);
        }
    }

    public void setTranslateY(double y) {
        double oldY = this.y;
        this.y = y;
        if (oldY != y) {
            this.pcs.firePropertyChange(VIEWPORT_TRANSLATE_Y_PROPERTY, oldY, y);
        }
    }

    public void setWidth(double width) {
        double oldWidth = this.width;
        this.width = width;
        if (oldWidth != width) {
            this.pcs.firePropertyChange(VIEWPORT_WIDTH_PROPERTY, oldWidth, width);
        }
    }
}

