/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.domain;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.inject.AdaptableScopes;
import org.eclipse.gef4.common.inject.AdapterMap;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractDomain<VR>
implements IDomain<VR> {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this, this.pcs);
    private AdaptableSupport<IDomain<VR>> ads = new AdaptableSupport((IAdaptable)this, this.pcs);
    private IOperationHistory operationHistory;
    private IUndoContext undoContext;
    private ForwardUndoCompositeOperation transaction;
    private Set<ITool<VR>> transactionContext = new HashSet<ITool<VR>>();

    public AbstractDomain() {
        AdaptableScopes.enter((IAdaptable)this);
    }

    public void activate() {
        if (!this.acs.isActive()) {
            this.acs.activate();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void closeExecutionTransaction(ITool<VR> tool) {
        this.transactionContext.remove(tool);
        if (this.transaction != null && !this.transaction.getOperations().isEmpty()) {
            this.transaction.setLabel(this.transaction.getOperations().iterator().next().getLabel());
            this.getOperationHistory().closeOperation(true, true, 1);
        } else {
            this.getOperationHistory().closeOperation(true, false, 1);
        }
        this.transaction = !this.transactionContext.isEmpty() ? this.createExecutionTransaction() : null;
    }

    protected ForwardUndoCompositeOperation createExecutionTransaction() {
        ForwardUndoCompositeOperation transaction = new ForwardUndoCompositeOperation("Transaction");
        transaction.addContext(this.getUndoContext());
        this.getOperationHistory().openOperation((ICompositeOperation)transaction, 1);
        return transaction;
    }

    public void deactivate() {
        if (this.acs.isActive()) {
            this.acs.deactivate();
        }
    }

    public void dispose() {
        this.operationHistory.dispose(this.undoContext, true, true, true);
        AdaptableScopes.leave((IAdaptable)this);
        this.ads.dispose();
    }

    @Override
    public void execute(IUndoableOperation operation) {
        IOperationHistory operationHistory = this.getOperationHistory();
        if (!this.isExecutionTransactionOpen()) {
            operation.addContext(this.getUndoContext());
        }
        try {
            operationHistory.execute(operation, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public <T> T getAdapter(AdapterKey<? super T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<? super T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<? super T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    @Override
    public Map<AdapterKey<? extends ITool<VR>>, ITool<VR>> getTools() {
        return this.ads.getAdapters(ITool.class);
    }

    @Override
    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    @Override
    public Map<AdapterKey<? extends IViewer<VR>>, IViewer<VR>> getViewers() {
        return this.ads.getAdapters(IViewer.class);
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    protected boolean isExecutionTransactionOpen() {
        return this.transaction != null;
    }

    @Override
    public boolean isExecutionTransactionOpen(ITool<VR> tool) {
        return this.transactionContext.contains(tool);
    }

    @Override
    public void openExecutionTransaction(ITool<VR> tool) {
        if (!this.isExecutionTransactionOpen()) {
            this.transaction = this.createExecutionTransaction();
        }
        this.transactionContext.add(tool);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public <T> void setAdapter(AdapterKey<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    public <T> void setAdapter(Class<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    public <T> void setAdapter(TypeToken<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    @Inject(optional=true)
    public void setAdapters(@AdapterMap Map<AdapterKey<?>, Object> adaptersWithKeys) {
        this.ads.setAdapters(adaptersWithKeys, false);
    }

    @Inject
    public void setOperationHistory(IOperationHistory stack) {
        this.operationHistory = stack;
    }

    @Inject
    public void setUndoContext(IUndoContext undoContext) {
        this.undoContext = undoContext;
    }

    public <T> T unsetAdapter(AdapterKey<? super T> key) {
        return (T)this.ads.unsetAdapter(key);
    }
}

