/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;

public class SelectionBehavior<VR>
extends AbstractBehavior<VR>
implements PropertyChangeListener {
    @Override
    public void activate() {
        super.activate();
        SelectionModel selectionModel = (SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class);
        selectionModel.addPropertyChangeListener(this);
        this.addFeedbackAndHandles(selectionModel.getSelected());
    }

    protected void addFeedbackAndHandles(List<? extends IContentPart<VR, ? extends VR>> selected) {
        if (this.getHost() instanceof IRootPart && selected.size() > 1) {
            this.addFeedback(selected);
            this.addHandles(selected);
        } else if (selected.contains(this.getHost())) {
            this.getHost().getRoot().getViewer().reveal(this.getHost());
            this.addFeedback(Collections.singletonList(this.getHost()));
            if (selected.get(0) == this.getHost() && selected.size() <= 1) {
                this.addHandles(Collections.singletonList(this.getHost()));
            }
        }
    }

    @Override
    public void deactivate() {
        SelectionModel selectionModel = (SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class);
        this.removeFeedbackAndHandles(selectionModel.getSelected());
        selectionModel.removePropertyChangeListener(this);
        super.deactivate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("selection")) {
            List oldSelection = (List)event.getOldValue();
            List newSelection = (List)event.getNewValue();
            this.removeFeedbackAndHandles(oldSelection);
            this.addFeedbackAndHandles(newSelection);
        }
    }

    protected void removeFeedbackAndHandles(List<? extends IContentPart<VR, ? extends VR>> selected) {
        if (this.getHost() instanceof IRootPart && selected.size() > 1) {
            this.removeHandles(selected);
            this.removeFeedback(selected);
        } else if (selected.contains(this.getHost())) {
            this.removeHandles(Collections.singletonList(this.getHost()));
            this.removeFeedback(Collections.singletonList(this.getHost()));
        }
    }
}

