/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnTypePolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXTypeTool
extends AbstractTool<Node> {
    public static final Class<AbstractFXOnTypePolicy> TOOL_POLICY_KEY = AbstractFXOnTypePolicy.class;
    private boolean isTypeInProgress = false;
    private final EventHandler<? super KeyEvent> pressedFilter = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            FXTypeTool.this.getDomain().openExecutionTransaction((ITool)FXTypeTool.this);
            Set<? extends AbstractFXOnTypePolicy> policies = FXTypeTool.this.getTargetPolicies(event);
            for (AbstractFXOnTypePolicy abstractFXOnTypePolicy : policies) {
                abstractFXOnTypePolicy.pressed(event);
            }
        }
    };
    private final EventHandler<? super KeyEvent> releasedFilter = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            Set<? extends AbstractFXOnTypePolicy> policies = FXTypeTool.this.getTargetPolicies(event);
            for (AbstractFXOnTypePolicy abstractFXOnTypePolicy : policies) {
                abstractFXOnTypePolicy.released(event);
            }
            FXTypeTool.this.getDomain().closeExecutionTransaction((ITool)FXTypeTool.this);
        }
    };

    protected Set<? extends AbstractFXOnTypePolicy> getKeyPolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(TOOL_POLICY_KEY).values());
    }

    protected Set<? extends AbstractFXOnTypePolicy> getTargetPolicies(KeyEvent event) {
        EventTarget target = event.getTarget();
        if (target instanceof Scene) {
            return this.getTargetPolicies((Scene)target);
        }
        if (target instanceof Node) {
            Scene scene = ((Node)target).getScene();
            if (scene == null) {
                return Collections.emptySet();
            }
            return this.getTargetPolicies(scene);
        }
        return Collections.emptySet();
    }

    protected Set<? extends AbstractFXOnTypePolicy> getTargetPolicies(Scene scene) {
        IContentPart targetPart = null;
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            if (!(viewer instanceof FXViewer) || ((FXViewer)viewer).getScene() != scene) continue;
            IContentPart part = ((FocusModel)viewer.getAdapter(FocusModel.class)).getFocused();
            if (part == null) {
                targetPart = viewer.getRootPart();
                break;
            }
            targetPart = part;
            break;
        }
        if (targetPart == null) {
            return Collections.emptySet();
        }
        return this.getKeyPolicies((IVisualPart<Node, ? extends Node>)targetPart);
    }

    protected void registerListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            scene.addEventFilter(KeyEvent.KEY_PRESSED, this.pressedFilter);
            scene.addEventFilter(KeyEvent.KEY_RELEASED, this.releasedFilter);
        }
    }

    protected void unregisterListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            scene.removeEventFilter(KeyEvent.KEY_PRESSED, this.pressedFilter);
            scene.removeEventFilter(KeyEvent.KEY_RELEASED, this.releasedFilter);
        }
    }
}

