/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ScrollEvent;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnScrollPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXScrollTool
extends AbstractTool<Node> {
    public static final Class<AbstractFXOnScrollPolicy> TOOL_POLICY_KEY = AbstractFXOnScrollPolicy.class;
    private final Map<FXViewer, EventHandler<ScrollEvent>> scrollListeners = new HashMap<FXViewer, EventHandler<ScrollEvent>>();

    private EventHandler<ScrollEvent> createScrollListener(final IViewer<Node> viewer) {
        return new EventHandler<ScrollEvent>(){

            protected Collection<? extends AbstractFXOnScrollPolicy> getTargetPolicies(ScrollEvent event) {
                EventTarget target = event.getTarget();
                if (!(target instanceof Node)) {
                    return Collections.emptyList();
                }
                Node targetNode = (Node)target;
                IRootPart targetPart = FXPartUtils.getTargetPart(Collections.singleton(viewer), targetNode, TOOL_POLICY_KEY, true);
                if (targetPart == null) {
                    targetPart = viewer.getRootPart();
                }
                Set<? extends AbstractFXOnScrollPolicy> policies = FXScrollTool.this.getScrollPolicies((IVisualPart<Node, ? extends Node>)targetPart);
                return policies;
            }

            public void handle(ScrollEvent event) {
                Collection<? extends AbstractFXOnScrollPolicy> policies = this.getTargetPolicies(event);
                for (AbstractFXOnScrollPolicy abstractFXOnScrollPolicy : policies) {
                    abstractFXOnScrollPolicy.scroll(event);
                }
            }
        };
    }

    protected Set<? extends AbstractFXOnScrollPolicy> getScrollPolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(TOOL_POLICY_KEY).values());
    }

    protected void registerListeners() {
        super.registerListeners();
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene = ((FXViewer)viewer).getScene();
            EventHandler<ScrollEvent> scrollListener = this.createScrollListener((IViewer<Node>)viewer);
            this.scrollListeners.put((FXViewer)viewer, scrollListener);
            scene.addEventFilter(ScrollEvent.SCROLL, scrollListener);
        }
    }

    protected void unregisterListeners() {
        for (Map.Entry<FXViewer, EventHandler<ScrollEvent>> e : this.scrollListeners.entrySet()) {
            Scene scene = e.getKey().getScene();
            scene.removeEventFilter(ScrollEvent.SCROLL, e.getValue());
        }
        super.unregisterListeners();
    }
}

