/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.gestures.FXMouseDragGesture;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnClickPolicy;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXClickDragTool
extends AbstractTool<Node> {
    public static final Class<AbstractFXOnClickPolicy> CLICK_TOOL_POLICY_KEY = AbstractFXOnClickPolicy.class;
    public static final Class<AbstractFXOnDragPolicy> DRAG_TOOL_POLICY_KEY = AbstractFXOnDragPolicy.class;
    private final Map<IViewer<Node>, FXMouseDragGesture> gestures = new HashMap<IViewer<Node>, FXMouseDragGesture>();
    private boolean dragInProgress;
    private final Map<AbstractFXOnDragPolicy, MouseEvent> pressEvents = new HashMap<AbstractFXOnDragPolicy, MouseEvent>();
    private Map<EventTarget, IVisualPart<Node, ? extends Node>> interactionTargetOverrides = new HashMap<EventTarget, IVisualPart<Node, ? extends Node>>();

    protected Set<? extends AbstractFXOnClickPolicy> getClickPolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(CLICK_TOOL_POLICY_KEY).values());
    }

    protected Set<? extends AbstractFXOnDragPolicy> getDragPolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(DRAG_TOOL_POLICY_KEY).values());
    }

    protected <T extends IPolicy<Node>> IVisualPart<Node, ? extends Node> getTargetPart(IViewer<Node> viewer, Node target, Class<T> policy) {
        if (this.interactionTargetOverrides.containsKey(target)) {
            IVisualPart<Node, ? extends Node> overridingTarget = this.interactionTargetOverrides.get(target);
            if (policy != null && overridingTarget.getAdapters(policy).isEmpty()) {
                return null;
            }
            return overridingTarget;
        }
        return FXPartUtils.getTargetPart(Collections.singleton(viewer), target, policy, true);
    }

    public void overrideTargetForThisInteraction(EventTarget target, IVisualPart<Node, ? extends Node> targetPart) {
        this.interactionTargetOverrides.put(target, targetPart);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            FXMouseDragGesture gesture = new FXMouseDragGesture(){

                protected void drag(Node target, MouseEvent e, double dx, double dy) {
                    if (!FXClickDragTool.this.dragInProgress) {
                        return;
                    }
                    IRootPart targetPart = FXClickDragTool.this.getTargetPart((IViewer<Node>)viewer, target, DRAG_TOOL_POLICY_KEY);
                    if (targetPart == null) {
                        targetPart = viewer.getRootPart();
                    }
                    Set<? extends AbstractFXOnDragPolicy> policies = FXClickDragTool.this.getDragPolicies((IVisualPart<Node, ? extends Node>)targetPart);
                    for (AbstractFXOnDragPolicy abstractFXOnDragPolicy : policies) {
                        abstractFXOnDragPolicy.drag(e, new Dimension(dx, dy));
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                protected void press(Node target, MouseEvent e) {
                    e.consume();
                    IRootPart clickTargetPart = FXClickDragTool.this.getTargetPart((IViewer<Node>)viewer, target, CLICK_TOOL_POLICY_KEY);
                    if (clickTargetPart == null) {
                        clickTargetPart = viewer.getRootPart();
                    }
                    Set<? extends AbstractFXOnClickPolicy> clickPolicies = FXClickDragTool.this.getClickPolicies((IVisualPart<Node, ? extends Node>)clickTargetPart);
                    FXClickDragTool.this.getDomain().openExecutionTransaction((ITool)FXClickDragTool.this);
                    for (AbstractFXOnClickPolicy abstractFXOnClickPolicy : clickPolicies) {
                        abstractFXOnClickPolicy.click(e);
                    }
                    FXClickDragTool.this.getDomain().closeExecutionTransaction((ITool)FXClickDragTool.this);
                    if (e.getClickCount() == 1) {
                        void var5_9;
                        IVisualPart<Node, Node> iVisualPart = FXClickDragTool.this.getTargetPart((IViewer<Node>)viewer, target, DRAG_TOOL_POLICY_KEY);
                        if (iVisualPart == null) {
                            IRootPart iRootPart = viewer.getRootPart();
                        }
                        Set<? extends AbstractFXOnDragPolicy> dragPolicies = FXClickDragTool.this.getDragPolicies((IVisualPart<Node, ? extends Node>)var5_9);
                        FXClickDragTool.this.getDomain().openExecutionTransaction((ITool)FXClickDragTool.this);
                        for (AbstractFXOnDragPolicy abstractFXOnDragPolicy : dragPolicies) {
                            FXClickDragTool.this.dragInProgress = true;
                            FXClickDragTool.this.pressEvents.put(abstractFXOnDragPolicy, e);
                            abstractFXOnDragPolicy.press(e);
                        }
                    }
                }

                protected void release(Node target, MouseEvent e, double dx, double dy) {
                    if (!FXClickDragTool.this.dragInProgress) {
                        return;
                    }
                    IRootPart targetPart = FXClickDragTool.this.getTargetPart((IViewer<Node>)viewer, target, DRAG_TOOL_POLICY_KEY);
                    if (targetPart == null) {
                        targetPart = viewer.getRootPart();
                    }
                    Set<? extends AbstractFXOnDragPolicy> policies = FXClickDragTool.this.getDragPolicies((IVisualPart<Node, ? extends Node>)targetPart);
                    for (AbstractFXOnDragPolicy abstractFXOnDragPolicy : policies) {
                        FXClickDragTool.this.pressEvents.remove((Object)abstractFXOnDragPolicy);
                        abstractFXOnDragPolicy.release(e, new Dimension(dx, dy));
                    }
                    FXClickDragTool.this.getDomain().closeExecutionTransaction((ITool)FXClickDragTool.this);
                    FXClickDragTool.this.dragInProgress = false;
                    FXClickDragTool.this.interactionTargetOverrides.clear();
                }
            };
            gesture.setScene(((FXViewer)viewer).getScene());
            this.gestures.put((IViewer<Node>)viewer, gesture);
        }
    }

    protected void unregisterListeners() {
        for (FXMouseDragGesture gesture : this.gestures.values()) {
            gesture.setScene(null);
        }
        super.unregisterListeners();
    }
}

