/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.fx.operations.FXResizeNodeOperation;
import org.eclipse.gef4.mvc.fx.operations.FXRevealOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public class FXResizePolicy
extends AbstractPolicy<Node>
implements ITransactional {
    protected FXResizeNodeOperation resizeOperation;
    protected ForwardUndoCompositeOperation forwardUndoOperation;

    public IUndoableOperation commit() {
        ForwardUndoCompositeOperation commit = this.forwardUndoOperation;
        this.forwardUndoOperation = null;
        this.resizeOperation = null;
        return commit;
    }

    protected double getMinimumHeight() {
        return 5.0;
    }

    protected double getMinimumWidth() {
        return 5.0;
    }

    public void init() {
        this.resizeOperation = new FXResizeNodeOperation((Node)this.getHost().getVisual());
        FXRevealOperation revealOperation = new FXRevealOperation((IVisualPart<Node, ? extends Node>)this.getHost());
        this.forwardUndoOperation = new ForwardUndoCompositeOperation(this.resizeOperation.getLabel());
        this.forwardUndoOperation.add((IUndoableOperation)this.resizeOperation);
        this.forwardUndoOperation.add((IUndoableOperation)revealOperation);
    }

    public void performResize(double dw, double dh) {
        double layoutDh;
        Node visual = (Node)this.getHost().getVisual();
        boolean resizable = visual.isResizable();
        double layoutDw = resizable ? dw : 0.0;
        double d = layoutDh = resizable ? dh : 0.0;
        if (resizable) {
            if (this.resizeOperation.getOldSize().width + layoutDw < this.getMinimumWidth()) {
                layoutDw = this.getMinimumWidth() - this.resizeOperation.getOldSize().width;
            }
            if (this.resizeOperation.getOldSize().height + layoutDh < this.getMinimumHeight()) {
                layoutDh = this.getMinimumHeight() - this.resizeOperation.getOldSize().height;
            }
        }
        this.updateOperation(layoutDw, layoutDh);
        try {
            this.forwardUndoOperation.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void updateOperation(double layoutDw, double layoutDh) {
        this.resizeOperation.setDw(layoutDw);
        this.resizeOperation.setDh(layoutDh);
    }
}

